/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransaction;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransactionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOfferingTransactionsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListOfferingTransactionsResponse> {
    private final List<OfferingTransaction> offeringTransactions;
    private final String nextToken;

    private ListOfferingTransactionsResponse(BuilderImpl builder) {
        super(builder);
        this.offeringTransactions = builder.offeringTransactions;
        this.nextToken = builder.nextToken;
    }

    public List<OfferingTransaction> offeringTransactions() {
        return this.offeringTransactions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTransactions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingTransactionsResponse)) {
            return false;
        }
        ListOfferingTransactionsResponse other = (ListOfferingTransactionsResponse)((Object)obj);
        return Objects.equals(this.offeringTransactions(), other.offeringTransactions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListOfferingTransactionsResponse").add("OfferingTransactions", this.offeringTransactions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringTransactions": {
                return Optional.of(clazz.cast(this.offeringTransactions()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<OfferingTransaction> offeringTransactions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingTransactionsResponse model) {
            super(model);
            this.offeringTransactions(model.offeringTransactions);
            this.nextToken(model.nextToken);
        }

        public final Collection<OfferingTransaction.Builder> getOfferingTransactions() {
            return this.offeringTransactions != null ? (Collection)this.offeringTransactions.stream().map(OfferingTransaction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offeringTransactions(Collection<OfferingTransaction> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copy(offeringTransactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(OfferingTransaction ... offeringTransactions) {
            this.offeringTransactions(Arrays.asList(offeringTransactions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(Consumer<OfferingTransaction.Builder> ... offeringTransactions) {
            this.offeringTransactions(Stream.of(offeringTransactions).map(c -> (OfferingTransaction)((OfferingTransaction.Builder)OfferingTransaction.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOfferingTransactions(Collection<OfferingTransaction.BuilderImpl> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copyFromBuilder(offeringTransactions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingTransactionsResponse build() {
            return new ListOfferingTransactionsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListOfferingTransactionsResponse> {
        public Builder offeringTransactions(Collection<OfferingTransaction> var1);

        public Builder offeringTransactions(OfferingTransaction ... var1);

        public Builder offeringTransactions(Consumer<OfferingTransaction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

