/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.transform.RemoteAccessSessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoteAccessSession
implements StructuredPojo,
ToCopyableBuilder<Builder, RemoteAccessSession> {
    private final String arn;
    private final String name;
    private final Date created;
    private final String status;
    private final String result;
    private final String message;
    private final Date started;
    private final Date stopped;
    private final Device device;
    private final String billingMethod;
    private final DeviceMinutes deviceMinutes;
    private final String endpoint;

    private RemoteAccessSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.message = builder.message;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.device = builder.device;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.endpoint = builder.endpoint;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public Date created() {
        return this.created;
    }

    public String status() {
        return this.status;
    }

    public String result() {
        return this.result;
    }

    public String message() {
        return this.message;
    }

    public Date started() {
        return this.started;
    }

    public Date stopped() {
        return this.stopped;
    }

    public Device device() {
        return this.device;
    }

    public String billingMethod() {
        return this.billingMethod;
    }

    public DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.result() == null ? 0 : this.result().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.started() == null ? 0 : this.started().hashCode());
        hashCode = 31 * hashCode + (this.stopped() == null ? 0 : this.stopped().hashCode());
        hashCode = 31 * hashCode + (this.device() == null ? 0 : this.device().hashCode());
        hashCode = 31 * hashCode + (this.billingMethod() == null ? 0 : this.billingMethod().hashCode());
        hashCode = 31 * hashCode + (this.deviceMinutes() == null ? 0 : this.deviceMinutes().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessSession)) {
            return false;
        }
        RemoteAccessSession other = (RemoteAccessSession)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.started() == null ^ this.started() == null) {
            return false;
        }
        if (other.started() != null && !other.started().equals(this.started())) {
            return false;
        }
        if (other.stopped() == null ^ this.stopped() == null) {
            return false;
        }
        if (other.stopped() != null && !other.stopped().equals(this.stopped())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.billingMethod() == null ^ this.billingMethod() == null) {
            return false;
        }
        if (other.billingMethod() != null && !other.billingMethod().equals(this.billingMethod())) {
            return false;
        }
        if (other.deviceMinutes() == null ^ this.deviceMinutes() == null) {
            return false;
        }
        if (other.deviceMinutes() != null && !other.deviceMinutes().equals(this.deviceMinutes())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        return other.endpoint() == null || other.endpoint().equals(this.endpoint());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.result() != null) {
            sb.append("Result: ").append(this.result()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.started() != null) {
            sb.append("Started: ").append(this.started()).append(",");
        }
        if (this.stopped() != null) {
            sb.append("Stopped: ").append(this.stopped()).append(",");
        }
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        if (this.billingMethod() != null) {
            sb.append("BillingMethod: ").append(this.billingMethod()).append(",");
        }
        if (this.deviceMinutes() != null) {
            sb.append("DeviceMinutes: ").append(this.deviceMinutes()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemoteAccessSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Date created;
        private String status;
        private String result;
        private String message;
        private Date started;
        private Date stopped;
        private Device device;
        private String billingMethod;
        private DeviceMinutes deviceMinutes;
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessSession model) {
            this.setArn(model.arn);
            this.setName(model.name);
            this.setCreated(model.created);
            this.setStatus(model.status);
            this.setResult(model.result);
            this.setMessage(model.message);
            this.setStarted(model.started);
            this.setStopped(model.stopped);
            this.setDevice(model.device);
            this.setBillingMethod(model.billingMethod);
            this.setDeviceMinutes(model.deviceMinutes);
            this.setEndpoint(model.endpoint);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Date getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Date created) {
            this.created = StandardMemberCopier.copy((Date)created);
            return this;
        }

        public final void setCreated(Date created) {
            this.created = StandardMemberCopier.copy((Date)created);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final void setResult(ExecutionResult result) {
            this.result(result.toString());
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Date getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Date started) {
            this.started = StandardMemberCopier.copy((Date)started);
            return this;
        }

        public final void setStarted(Date started) {
            this.started = StandardMemberCopier.copy((Date)started);
        }

        public final Date getStopped() {
            return this.stopped;
        }

        @Override
        public final Builder stopped(Date stopped) {
            this.stopped = StandardMemberCopier.copy((Date)stopped);
            return this;
        }

        public final void setStopped(Date stopped) {
            this.stopped = StandardMemberCopier.copy((Date)stopped);
        }

        public final Device getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device device) {
            this.device = device;
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final void setBillingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
        }

        public final DeviceMinutes getDeviceMinutes() {
            return this.deviceMinutes;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public RemoteAccessSession build() {
            return new RemoteAccessSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemoteAccessSession> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder created(Date var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder message(String var1);

        public Builder started(Date var1);

        public Builder stopped(Date var1);

        public Builder device(Device var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder deviceMinutes(DeviceMinutes var1);

        public Builder endpoint(String var1);
    }
}

