/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSessionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRemoteAccessSessionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
    private final List<RemoteAccessSession> remoteAccessSessions;
    private final String nextToken;

    private ListRemoteAccessSessionsResponse(BuilderImpl builder) {
        this.remoteAccessSessions = builder.remoteAccessSessions;
        this.nextToken = builder.nextToken;
    }

    public List<RemoteAccessSession> remoteAccessSessions() {
        return this.remoteAccessSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.remoteAccessSessions() == null ? 0 : this.remoteAccessSessions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRemoteAccessSessionsResponse)) {
            return false;
        }
        ListRemoteAccessSessionsResponse other = (ListRemoteAccessSessionsResponse)((Object)obj);
        if (other.remoteAccessSessions() == null ^ this.remoteAccessSessions() == null) {
            return false;
        }
        if (other.remoteAccessSessions() != null && !other.remoteAccessSessions().equals(this.remoteAccessSessions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.remoteAccessSessions() != null) {
            sb.append("RemoteAccessSessions: ").append(this.remoteAccessSessions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<RemoteAccessSession> remoteAccessSessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRemoteAccessSessionsResponse model) {
            this.setRemoteAccessSessions(model.remoteAccessSessions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<RemoteAccessSession> getRemoteAccessSessions() {
            return this.remoteAccessSessions;
        }

        @Override
        public final Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copy(remoteAccessSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteAccessSessions(RemoteAccessSession ... remoteAccessSessions) {
            if (this.remoteAccessSessions == null) {
                this.remoteAccessSessions = new ArrayList<RemoteAccessSession>(remoteAccessSessions.length);
            }
            for (RemoteAccessSession e : remoteAccessSessions) {
                this.remoteAccessSessions.add(e);
            }
            return this;
        }

        public final void setRemoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copy(remoteAccessSessions);
        }

        @SafeVarargs
        public final void setRemoteAccessSessions(RemoteAccessSession ... remoteAccessSessions) {
            if (this.remoteAccessSessions == null) {
                this.remoteAccessSessions = new ArrayList<RemoteAccessSession>(remoteAccessSessions.length);
            }
            for (RemoteAccessSession e : remoteAccessSessions) {
                this.remoteAccessSessions.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListRemoteAccessSessionsResponse build() {
            return new ListRemoteAccessSessionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
        public Builder remoteAccessSessions(Collection<RemoteAccessSession> var1);

        public Builder remoteAccessSessions(RemoteAccessSession ... var1);

        public Builder nextToken(String var1);
    }
}

