/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage;
import software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessagesCopier;
import software.amazon.awssdk.services.devicefarm.transform.DevicePoolCompatibilityResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DevicePoolCompatibilityResult
implements StructuredPojo,
ToCopyableBuilder<Builder, DevicePoolCompatibilityResult> {
    private final Device device;
    private final Boolean compatible;
    private final List<IncompatibilityMessage> incompatibilityMessages;

    private DevicePoolCompatibilityResult(BuilderImpl builder) {
        this.device = builder.device;
        this.compatible = builder.compatible;
        this.incompatibilityMessages = builder.incompatibilityMessages;
    }

    public Device device() {
        return this.device;
    }

    public Boolean compatible() {
        return this.compatible;
    }

    public List<IncompatibilityMessage> incompatibilityMessages() {
        return this.incompatibilityMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.device() == null ? 0 : this.device().hashCode());
        hashCode = 31 * hashCode + (this.compatible() == null ? 0 : this.compatible().hashCode());
        hashCode = 31 * hashCode + (this.incompatibilityMessages() == null ? 0 : this.incompatibilityMessages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePoolCompatibilityResult)) {
            return false;
        }
        DevicePoolCompatibilityResult other = (DevicePoolCompatibilityResult)obj;
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.compatible() == null ^ this.compatible() == null) {
            return false;
        }
        if (other.compatible() != null && !other.compatible().equals(this.compatible())) {
            return false;
        }
        if (other.incompatibilityMessages() == null ^ this.incompatibilityMessages() == null) {
            return false;
        }
        return other.incompatibilityMessages() == null || other.incompatibilityMessages().equals(this.incompatibilityMessages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        if (this.compatible() != null) {
            sb.append("Compatible: ").append(this.compatible()).append(",");
        }
        if (this.incompatibilityMessages() != null) {
            sb.append("IncompatibilityMessages: ").append(this.incompatibilityMessages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DevicePoolCompatibilityResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Device device;
        private Boolean compatible;
        private List<IncompatibilityMessage> incompatibilityMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(DevicePoolCompatibilityResult model) {
            this.setDevice(model.device);
            this.setCompatible(model.compatible);
            this.setIncompatibilityMessages(model.incompatibilityMessages);
        }

        public final Device getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device device) {
            this.device = device;
        }

        public final Boolean getCompatible() {
            return this.compatible;
        }

        @Override
        public final Builder compatible(Boolean compatible) {
            this.compatible = compatible;
            return this;
        }

        public final void setCompatible(Boolean compatible) {
            this.compatible = compatible;
        }

        public final Collection<IncompatibilityMessage> getIncompatibilityMessages() {
            return this.incompatibilityMessages;
        }

        @Override
        public final Builder incompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copy(incompatibilityMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibilityMessages(IncompatibilityMessage ... incompatibilityMessages) {
            if (this.incompatibilityMessages == null) {
                this.incompatibilityMessages = new ArrayList<IncompatibilityMessage>(incompatibilityMessages.length);
            }
            for (IncompatibilityMessage e : incompatibilityMessages) {
                this.incompatibilityMessages.add(e);
            }
            return this;
        }

        public final void setIncompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copy(incompatibilityMessages);
        }

        @SafeVarargs
        public final void setIncompatibilityMessages(IncompatibilityMessage ... incompatibilityMessages) {
            if (this.incompatibilityMessages == null) {
                this.incompatibilityMessages = new ArrayList<IncompatibilityMessage>(incompatibilityMessages.length);
            }
            for (IncompatibilityMessage e : incompatibilityMessages) {
                this.incompatibilityMessages.add(e);
            }
        }

        public DevicePoolCompatibilityResult build() {
            return new DevicePoolCompatibilityResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DevicePoolCompatibilityResult> {
        public Builder device(Device var1);

        public Builder compatible(Boolean var1);

        public Builder incompatibilityMessages(Collection<IncompatibilityMessage> var1);

        public Builder incompatibilityMessages(IncompatibilityMessage ... var1);
    }
}

