/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.DetectiveRequest;
import software.amazon.awssdk.services.detective.model.FilterCriteria;
import software.amazon.awssdk.services.detective.model.SortCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvestigationsRequest
extends DetectiveRequest
implements ToCopyableBuilder<Builder, ListInvestigationsRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(ListInvestigationsRequest.getter(ListInvestigationsRequest::graphArn)).setter(ListInvestigationsRequest.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInvestigationsRequest.getter(ListInvestigationsRequest::nextToken)).setter(ListInvestigationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInvestigationsRequest.getter(ListInvestigationsRequest::maxResults)).setter(ListInvestigationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(ListInvestigationsRequest.getter(ListInvestigationsRequest::filterCriteria)).setter(ListInvestigationsRequest.setter(Builder::filterCriteria)).constructor(FilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()}).build();
    private static final SdkField<SortCriteria> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortCriteria").getter(ListInvestigationsRequest.getter(ListInvestigationsRequest::sortCriteria)).setter(ListInvestigationsRequest.setter(Builder::sortCriteria)).constructor(SortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_CRITERIA_FIELD, SORT_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInvestigationsRequest.memberNameToFieldInitializer();
    private final String graphArn;
    private final String nextToken;
    private final Integer maxResults;
    private final FilterCriteria filterCriteria;
    private final SortCriteria sortCriteria;

    private ListInvestigationsRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filterCriteria = builder.filterCriteria;
        this.sortCriteria = builder.sortCriteria;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final FilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final SortCriteria sortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvestigationsRequest)) {
            return false;
        }
        ListInvestigationsRequest other = (ListInvestigationsRequest)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.sortCriteria(), other.sortCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"ListInvestigationsRequest").add("GraphArn", (Object)this.graphArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("FilterCriteria", (Object)this.filterCriteria()).add("SortCriteria", (Object)this.sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "SortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GraphArn", GRAPH_ARN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("FilterCriteria", FILTER_CRITERIA_FIELD);
        map.put("SortCriteria", SORT_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvestigationsRequest, T> g) {
        return obj -> g.apply((ListInvestigationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveRequest.BuilderImpl
    implements Builder {
        private String graphArn;
        private String nextToken;
        private Integer maxResults;
        private FilterCriteria filterCriteria;
        private SortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvestigationsRequest model) {
            super(model);
            this.graphArn(model.graphArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filterCriteria(model.filterCriteria);
            this.sortCriteria(model.sortCriteria);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final SortCriteria.Builder getSortCriteria() {
            return this.sortCriteria != null ? this.sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(SortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInvestigationsRequest build() {
            return new ListInvestigationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DetectiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvestigationsRequest> {
        public Builder graphArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filterCriteria(FilterCriteria var1);

        default public Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((FilterCriteria)((FilterCriteria.Builder)FilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder sortCriteria(SortCriteria var1);

        default public Builder sortCriteria(Consumer<SortCriteria.Builder> sortCriteria) {
            return this.sortCriteria((SortCriteria)((SortCriteria.Builder)SortCriteria.builder().applyMutation(sortCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

