/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.InvestigationDetail;
import software.amazon.awssdk.services.detective.model.InvestigationDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvestigationsResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, ListInvestigationsResponse> {
    private static final SdkField<List<InvestigationDetail>> INVESTIGATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvestigationDetails").getter(ListInvestigationsResponse.getter(ListInvestigationsResponse::investigationDetails)).setter(ListInvestigationsResponse.setter(Builder::investigationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvestigationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInvestigationsResponse.getter(ListInvestigationsResponse::nextToken)).setter(ListInvestigationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVESTIGATION_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInvestigationsResponse.memberNameToFieldInitializer();
    private final List<InvestigationDetail> investigationDetails;
    private final String nextToken;

    private ListInvestigationsResponse(BuilderImpl builder) {
        super(builder);
        this.investigationDetails = builder.investigationDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInvestigationDetails() {
        return this.investigationDetails != null && !(this.investigationDetails instanceof SdkAutoConstructList);
    }

    public final List<InvestigationDetail> investigationDetails() {
        return this.investigationDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvestigationDetails() ? this.investigationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvestigationsResponse)) {
            return false;
        }
        ListInvestigationsResponse other = (ListInvestigationsResponse)((Object)obj);
        return this.hasInvestigationDetails() == other.hasInvestigationDetails() && Objects.equals(this.investigationDetails(), other.investigationDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInvestigationsResponse").add("InvestigationDetails", this.hasInvestigationDetails() ? this.investigationDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvestigationDetails": {
                return Optional.ofNullable(clazz.cast(this.investigationDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InvestigationDetails", INVESTIGATION_DETAILS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvestigationsResponse, T> g) {
        return obj -> g.apply((ListInvestigationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<InvestigationDetail> investigationDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvestigationsResponse model) {
            super(model);
            this.investigationDetails(model.investigationDetails);
            this.nextToken(model.nextToken);
        }

        public final List<InvestigationDetail.Builder> getInvestigationDetails() {
            List<InvestigationDetail.Builder> result = InvestigationDetailsCopier.copyToBuilder(this.investigationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvestigationDetails(Collection<InvestigationDetail.BuilderImpl> investigationDetails) {
            this.investigationDetails = InvestigationDetailsCopier.copyFromBuilder(investigationDetails);
        }

        @Override
        public final Builder investigationDetails(Collection<InvestigationDetail> investigationDetails) {
            this.investigationDetails = InvestigationDetailsCopier.copy(investigationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationDetails(InvestigationDetail ... investigationDetails) {
            this.investigationDetails(Arrays.asList(investigationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationDetails(Consumer<InvestigationDetail.Builder> ... investigationDetails) {
            this.investigationDetails(Stream.of(investigationDetails).map(c -> (InvestigationDetail)((InvestigationDetail.Builder)InvestigationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvestigationsResponse build() {
            return new ListInvestigationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvestigationsResponse> {
        public Builder investigationDetails(Collection<InvestigationDetail> var1);

        public Builder investigationDetails(InvestigationDetail ... var1);

        public Builder investigationDetails(Consumer<InvestigationDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

