/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.AccountIdListCopier;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.UnprocessedAccount;
import software.amazon.awssdk.services.detective.model.UnprocessedAccountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteMembersResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, DeleteMembersResponse> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(DeleteMembersResponse.getter(DeleteMembersResponse::accountIds)).setter(DeleteMembersResponse.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAccounts").getter(DeleteMembersResponse.getter(DeleteMembersResponse::unprocessedAccounts)).setter(DeleteMembersResponse.setter(Builder::unprocessedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, UNPROCESSED_ACCOUNTS_FIELD));
    private final List<String> accountIds;
    private final List<UnprocessedAccount> unprocessedAccounts;

    private DeleteMembersResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasUnprocessedAccounts() {
        return this.unprocessedAccounts != null && !(this.unprocessedAccounts instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedAccount> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMembersResponse)) {
            return false;
        }
        DeleteMembersResponse other = (DeleteMembersResponse)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasUnprocessedAccounts() == other.hasUnprocessedAccounts() && Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteMembersResponse").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("UnprocessedAccounts", this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "UnprocessedAccounts": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMembersResponse, T> g) {
        return obj -> g.apply((DeleteMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMembersResponse model) {
            super(model);
            this.accountIds(model.accountIds);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        @Transient
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = UnprocessedAccountListCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        @Transient
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... unprocessedAccounts) {
            this.unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> (UnprocessedAccount)((UnprocessedAccount.Builder)UnprocessedAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteMembersResponse build() {
            return new DeleteMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteMembersResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder unprocessedAccounts(Collection<UnprocessedAccount> var1);

        public Builder unprocessedAccounts(UnprocessedAccount ... var1);

        public Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... var1);
    }
}

