/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.AcquiredLimit;
import software.amazon.awssdk.services.deadline.model.AcquiredLimitsCopier;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.SessionActionDefinition;
import software.amazon.awssdk.services.deadline.model.SessionActionStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunManifestPropertiesListResponseCopier;
import software.amazon.awssdk.services.deadline.model.TaskRunManifestPropertiesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionActionResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetSessionActionResponse> {
    private static final SdkField<String> SESSION_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionActionId").getter(GetSessionActionResponse.getter(GetSessionActionResponse::sessionActionId)).setter(GetSessionActionResponse.setter(Builder::sessionActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSessionActionResponse.getter(GetSessionActionResponse::statusAsString)).setter(GetSessionActionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetSessionActionResponse.getter(GetSessionActionResponse::startedAt)).setter(GetSessionActionResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetSessionActionResponse.getter(GetSessionActionResponse::endedAt)).setter(GetSessionActionResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> WORKER_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("workerUpdatedAt").getter(GetSessionActionResponse.getter(GetSessionActionResponse::workerUpdatedAt)).setter(GetSessionActionResponse.setter(Builder::workerUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Float> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("progressPercent").getter(GetSessionActionResponse.getter(GetSessionActionResponse::progressPercent)).setter(GetSessionActionResponse.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercent").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetSessionActionResponse.getter(GetSessionActionResponse::sessionId)).setter(GetSessionActionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Integer> PROCESS_EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("processExitCode").getter(GetSessionActionResponse.getter(GetSessionActionResponse::processExitCode)).setter(GetSessionActionResponse.setter(Builder::processExitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processExitCode").build()}).build();
    private static final SdkField<String> PROGRESS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("progressMessage").getter(GetSessionActionResponse.getter(GetSessionActionResponse::progressMessage)).setter(GetSessionActionResponse.setter(Builder::progressMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressMessage").build()}).build();
    private static final SdkField<SessionActionDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(GetSessionActionResponse.getter(GetSessionActionResponse::definition)).setter(GetSessionActionResponse.setter(Builder::definition)).constructor(SessionActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<List<AcquiredLimit>> ACQUIRED_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acquiredLimits").getter(GetSessionActionResponse.getter(GetSessionActionResponse::acquiredLimits)).setter(GetSessionActionResponse.setter(Builder::acquiredLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acquiredLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcquiredLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TaskRunManifestPropertiesResponse>> MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("manifests").getter(GetSessionActionResponse.getter(GetSessionActionResponse::manifests)).setter(GetSessionActionResponse.setter(Builder::manifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskRunManifestPropertiesResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ACTION_ID_FIELD, STATUS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, WORKER_UPDATED_AT_FIELD, PROGRESS_PERCENT_FIELD, SESSION_ID_FIELD, PROCESS_EXIT_CODE_FIELD, PROGRESS_MESSAGE_FIELD, DEFINITION_FIELD, ACQUIRED_LIMITS_FIELD, MANIFESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionActionResponse.memberNameToFieldInitializer();
    private final String sessionActionId;
    private final String status;
    private final Instant startedAt;
    private final Instant endedAt;
    private final Instant workerUpdatedAt;
    private final Float progressPercent;
    private final String sessionId;
    private final Integer processExitCode;
    private final String progressMessage;
    private final SessionActionDefinition definition;
    private final List<AcquiredLimit> acquiredLimits;
    private final List<TaskRunManifestPropertiesResponse> manifests;

    private GetSessionActionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionActionId = builder.sessionActionId;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.workerUpdatedAt = builder.workerUpdatedAt;
        this.progressPercent = builder.progressPercent;
        this.sessionId = builder.sessionId;
        this.processExitCode = builder.processExitCode;
        this.progressMessage = builder.progressMessage;
        this.definition = builder.definition;
        this.acquiredLimits = builder.acquiredLimits;
        this.manifests = builder.manifests;
    }

    public final String sessionActionId() {
        return this.sessionActionId;
    }

    public final SessionActionStatus status() {
        return SessionActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant workerUpdatedAt() {
        return this.workerUpdatedAt;
    }

    public final Float progressPercent() {
        return this.progressPercent;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Integer processExitCode() {
        return this.processExitCode;
    }

    public final String progressMessage() {
        return this.progressMessage;
    }

    public final SessionActionDefinition definition() {
        return this.definition;
    }

    public final boolean hasAcquiredLimits() {
        return this.acquiredLimits != null && !(this.acquiredLimits instanceof SdkAutoConstructList);
    }

    public final List<AcquiredLimit> acquiredLimits() {
        return this.acquiredLimits;
    }

    public final boolean hasManifests() {
        return this.manifests != null && !(this.manifests instanceof SdkAutoConstructList);
    }

    public final List<TaskRunManifestPropertiesResponse> manifests() {
        return this.manifests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.processExitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcquiredLimits() ? this.acquiredLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManifests() ? this.manifests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionActionResponse)) {
            return false;
        }
        GetSessionActionResponse other = (GetSessionActionResponse)((Object)obj);
        return Objects.equals(this.sessionActionId(), other.sessionActionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.workerUpdatedAt(), other.workerUpdatedAt()) && Objects.equals(this.progressPercent(), other.progressPercent()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.processExitCode(), other.processExitCode()) && Objects.equals(this.progressMessage(), other.progressMessage()) && Objects.equals(this.definition(), other.definition()) && this.hasAcquiredLimits() == other.hasAcquiredLimits() && Objects.equals(this.acquiredLimits(), other.acquiredLimits()) && this.hasManifests() == other.hasManifests() && Objects.equals(this.manifests(), other.manifests());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionActionResponse").add("SessionActionId", (Object)this.sessionActionId()).add("Status", (Object)this.statusAsString()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("WorkerUpdatedAt", (Object)this.workerUpdatedAt()).add("ProgressPercent", (Object)this.progressPercent()).add("SessionId", (Object)this.sessionId()).add("ProcessExitCode", (Object)this.processExitCode()).add("ProgressMessage", (Object)(this.progressMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("Definition", (Object)this.definition()).add("AcquiredLimits", this.hasAcquiredLimits() ? this.acquiredLimits() : null).add("Manifests", this.hasManifests() ? this.manifests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionActionId": {
                return Optional.ofNullable(clazz.cast(this.sessionActionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "workerUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.workerUpdatedAt()));
            }
            case "progressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "processExitCode": {
                return Optional.ofNullable(clazz.cast(this.processExitCode()));
            }
            case "progressMessage": {
                return Optional.ofNullable(clazz.cast(this.progressMessage()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "acquiredLimits": {
                return Optional.ofNullable(clazz.cast(this.acquiredLimits()));
            }
            case "manifests": {
                return Optional.ofNullable(clazz.cast(this.manifests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionActionId", SESSION_ACTION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("workerUpdatedAt", WORKER_UPDATED_AT_FIELD);
        map.put("progressPercent", PROGRESS_PERCENT_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("processExitCode", PROCESS_EXIT_CODE_FIELD);
        map.put("progressMessage", PROGRESS_MESSAGE_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("acquiredLimits", ACQUIRED_LIMITS_FIELD);
        map.put("manifests", MANIFESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionActionResponse, T> g) {
        return obj -> g.apply((GetSessionActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String sessionActionId;
        private String status;
        private Instant startedAt;
        private Instant endedAt;
        private Instant workerUpdatedAt;
        private Float progressPercent;
        private String sessionId;
        private Integer processExitCode;
        private String progressMessage;
        private SessionActionDefinition definition;
        private List<AcquiredLimit> acquiredLimits = DefaultSdkAutoConstructList.getInstance();
        private List<TaskRunManifestPropertiesResponse> manifests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionActionResponse model) {
            super(model);
            this.sessionActionId(model.sessionActionId);
            this.status(model.status);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.workerUpdatedAt(model.workerUpdatedAt);
            this.progressPercent(model.progressPercent);
            this.sessionId(model.sessionId);
            this.processExitCode(model.processExitCode);
            this.progressMessage(model.progressMessage);
            this.definition(model.definition);
            this.acquiredLimits(model.acquiredLimits);
            this.manifests(model.manifests);
        }

        public final String getSessionActionId() {
            return this.sessionActionId;
        }

        public final void setSessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
        }

        @Override
        public final Builder sessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getWorkerUpdatedAt() {
            return this.workerUpdatedAt;
        }

        public final void setWorkerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
        }

        @Override
        public final Builder workerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
            return this;
        }

        public final Float getProgressPercent() {
            return this.progressPercent;
        }

        public final void setProgressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Integer getProcessExitCode() {
            return this.processExitCode;
        }

        public final void setProcessExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
        }

        @Override
        public final Builder processExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
            return this;
        }

        public final String getProgressMessage() {
            return this.progressMessage;
        }

        public final void setProgressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
        }

        @Override
        public final Builder progressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
            return this;
        }

        public final SessionActionDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(SessionActionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(SessionActionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final List<AcquiredLimit.Builder> getAcquiredLimits() {
            List<AcquiredLimit.Builder> result = AcquiredLimitsCopier.copyToBuilder(this.acquiredLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcquiredLimits(Collection<AcquiredLimit.BuilderImpl> acquiredLimits) {
            this.acquiredLimits = AcquiredLimitsCopier.copyFromBuilder(acquiredLimits);
        }

        @Override
        public final Builder acquiredLimits(Collection<AcquiredLimit> acquiredLimits) {
            this.acquiredLimits = AcquiredLimitsCopier.copy(acquiredLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acquiredLimits(AcquiredLimit ... acquiredLimits) {
            this.acquiredLimits(Arrays.asList(acquiredLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acquiredLimits(Consumer<AcquiredLimit.Builder> ... acquiredLimits) {
            this.acquiredLimits(Stream.of(acquiredLimits).map(c -> (AcquiredLimit)((AcquiredLimit.Builder)AcquiredLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TaskRunManifestPropertiesResponse.Builder> getManifests() {
            List<TaskRunManifestPropertiesResponse.Builder> result = TaskRunManifestPropertiesListResponseCopier.copyToBuilder(this.manifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManifests(Collection<TaskRunManifestPropertiesResponse.BuilderImpl> manifests) {
            this.manifests = TaskRunManifestPropertiesListResponseCopier.copyFromBuilder(manifests);
        }

        @Override
        public final Builder manifests(Collection<TaskRunManifestPropertiesResponse> manifests) {
            this.manifests = TaskRunManifestPropertiesListResponseCopier.copy(manifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(TaskRunManifestPropertiesResponse ... manifests) {
            this.manifests(Arrays.asList(manifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(Consumer<TaskRunManifestPropertiesResponse.Builder> ... manifests) {
            this.manifests(Stream.of(manifests).map(c -> (TaskRunManifestPropertiesResponse)((TaskRunManifestPropertiesResponse.Builder)TaskRunManifestPropertiesResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSessionActionResponse build() {
            return new GetSessionActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionActionResponse> {
        public Builder sessionActionId(String var1);

        public Builder status(String var1);

        public Builder status(SessionActionStatus var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder workerUpdatedAt(Instant var1);

        public Builder progressPercent(Float var1);

        public Builder sessionId(String var1);

        public Builder processExitCode(Integer var1);

        public Builder progressMessage(String var1);

        public Builder definition(SessionActionDefinition var1);

        default public Builder definition(Consumer<SessionActionDefinition.Builder> definition) {
            return this.definition((SessionActionDefinition)((SessionActionDefinition.Builder)SessionActionDefinition.builder().applyMutation(definition)).build());
        }

        public Builder acquiredLimits(Collection<AcquiredLimit> var1);

        public Builder acquiredLimits(AcquiredLimit ... var1);

        public Builder acquiredLimits(Consumer<AcquiredLimit.Builder> ... var1);

        public Builder manifests(Collection<TaskRunManifestPropertiesResponse> var1);

        public Builder manifests(TaskRunManifestPropertiesResponse ... var1);

        public Builder manifests(Consumer<TaskRunManifestPropertiesResponse.Builder> ... var1);
    }
}

