/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.AutoScalingMode;
import software.amazon.awssdk.services.deadline.model.CustomerManagedWorkerCapabilities;
import software.amazon.awssdk.services.deadline.model.TagPropagationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerManagedFleetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerManagedFleetConfiguration> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(CustomerManagedFleetConfiguration.getter(CustomerManagedFleetConfiguration::modeAsString)).setter(CustomerManagedFleetConfiguration.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<CustomerManagedWorkerCapabilities> WORKER_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workerCapabilities").getter(CustomerManagedFleetConfiguration.getter(CustomerManagedFleetConfiguration::workerCapabilities)).setter(CustomerManagedFleetConfiguration.setter(Builder::workerCapabilities)).constructor(CustomerManagedWorkerCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerCapabilities").build()}).build();
    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageProfileId").getter(CustomerManagedFleetConfiguration.getter(CustomerManagedFleetConfiguration::storageProfileId)).setter(CustomerManagedFleetConfiguration.setter(Builder::storageProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()}).build();
    private static final SdkField<String> TAG_PROPAGATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tagPropagationMode").getter(CustomerManagedFleetConfiguration.getter(CustomerManagedFleetConfiguration::tagPropagationModeAsString)).setter(CustomerManagedFleetConfiguration.setter(Builder::tagPropagationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagPropagationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, WORKER_CAPABILITIES_FIELD, STORAGE_PROFILE_ID_FIELD, TAG_PROPAGATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomerManagedFleetConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final CustomerManagedWorkerCapabilities workerCapabilities;
    private final String storageProfileId;
    private final String tagPropagationMode;

    private CustomerManagedFleetConfiguration(BuilderImpl builder) {
        this.mode = builder.mode;
        this.workerCapabilities = builder.workerCapabilities;
        this.storageProfileId = builder.storageProfileId;
        this.tagPropagationMode = builder.tagPropagationMode;
    }

    public final AutoScalingMode mode() {
        return AutoScalingMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final CustomerManagedWorkerCapabilities workerCapabilities() {
        return this.workerCapabilities;
    }

    public final String storageProfileId() {
        return this.storageProfileId;
    }

    public final TagPropagationMode tagPropagationMode() {
        return TagPropagationMode.fromValue(this.tagPropagationMode);
    }

    public final String tagPropagationModeAsString() {
        return this.tagPropagationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagPropagationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedFleetConfiguration)) {
            return false;
        }
        CustomerManagedFleetConfiguration other = (CustomerManagedFleetConfiguration)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.workerCapabilities(), other.workerCapabilities()) && Objects.equals(this.storageProfileId(), other.storageProfileId()) && Objects.equals(this.tagPropagationModeAsString(), other.tagPropagationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerManagedFleetConfiguration").add("Mode", (Object)this.modeAsString()).add("WorkerCapabilities", (Object)this.workerCapabilities()).add("StorageProfileId", (Object)this.storageProfileId()).add("TagPropagationMode", (Object)this.tagPropagationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "workerCapabilities": {
                return Optional.ofNullable(clazz.cast(this.workerCapabilities()));
            }
            case "storageProfileId": {
                return Optional.ofNullable(clazz.cast(this.storageProfileId()));
            }
            case "tagPropagationMode": {
                return Optional.ofNullable(clazz.cast(this.tagPropagationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mode", MODE_FIELD);
        map.put("workerCapabilities", WORKER_CAPABILITIES_FIELD);
        map.put("storageProfileId", STORAGE_PROFILE_ID_FIELD);
        map.put("tagPropagationMode", TAG_PROPAGATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedFleetConfiguration, T> g) {
        return obj -> g.apply((CustomerManagedFleetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private CustomerManagedWorkerCapabilities workerCapabilities;
        private String storageProfileId;
        private String tagPropagationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedFleetConfiguration model) {
            this.mode(model.mode);
            this.workerCapabilities(model.workerCapabilities);
            this.storageProfileId(model.storageProfileId);
            this.tagPropagationMode(model.tagPropagationMode);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AutoScalingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final CustomerManagedWorkerCapabilities.Builder getWorkerCapabilities() {
            return this.workerCapabilities != null ? this.workerCapabilities.toBuilder() : null;
        }

        public final void setWorkerCapabilities(CustomerManagedWorkerCapabilities.BuilderImpl workerCapabilities) {
            this.workerCapabilities = workerCapabilities != null ? workerCapabilities.build() : null;
        }

        @Override
        public final Builder workerCapabilities(CustomerManagedWorkerCapabilities workerCapabilities) {
            this.workerCapabilities = workerCapabilities;
            return this;
        }

        public final String getStorageProfileId() {
            return this.storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getTagPropagationMode() {
            return this.tagPropagationMode;
        }

        public final void setTagPropagationMode(String tagPropagationMode) {
            this.tagPropagationMode = tagPropagationMode;
        }

        @Override
        public final Builder tagPropagationMode(String tagPropagationMode) {
            this.tagPropagationMode = tagPropagationMode;
            return this;
        }

        @Override
        public final Builder tagPropagationMode(TagPropagationMode tagPropagationMode) {
            this.tagPropagationMode(tagPropagationMode == null ? null : tagPropagationMode.toString());
            return this;
        }

        public CustomerManagedFleetConfiguration build() {
            return new CustomerManagedFleetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerManagedFleetConfiguration> {
        public Builder mode(String var1);

        public Builder mode(AutoScalingMode var1);

        public Builder workerCapabilities(CustomerManagedWorkerCapabilities var1);

        default public Builder workerCapabilities(Consumer<CustomerManagedWorkerCapabilities.Builder> workerCapabilities) {
            return this.workerCapabilities((CustomerManagedWorkerCapabilities)((CustomerManagedWorkerCapabilities.Builder)CustomerManagedWorkerCapabilities.builder().applyMutation(workerCapabilities)).build());
        }

        public Builder storageProfileId(String var1);

        public Builder tagPropagationMode(String var1);

        public Builder tagPropagationMode(TagPropagationMode var1);
    }
}

