/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.MonitorSummariesCopier;
import software.amazon.awssdk.services.deadline.model.MonitorSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitorsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListMonitorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMonitorsResponse.getter(ListMonitorsResponse::nextToken)).setter(ListMonitorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<MonitorSummary>> MONITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("monitors").getter(ListMonitorsResponse.getter(ListMonitorsResponse::monitors)).setter(ListMonitorsResponse.setter(Builder::monitors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MONITORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMonitorsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MonitorSummary> monitors;

    private ListMonitorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.monitors = builder.monitors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMonitors() {
        return this.monitors != null && !(this.monitors instanceof SdkAutoConstructList);
    }

    public final List<MonitorSummary> monitors() {
        return this.monitors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitors() ? this.monitors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitorsResponse)) {
            return false;
        }
        ListMonitorsResponse other = (ListMonitorsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMonitors() == other.hasMonitors() && Objects.equals(this.monitors(), other.monitors());
    }

    public final String toString() {
        return ToString.builder((String)"ListMonitorsResponse").add("NextToken", (Object)this.nextToken()).add("Monitors", this.hasMonitors() ? this.monitors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "monitors": {
                return Optional.ofNullable(clazz.cast(this.monitors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("monitors", MONITORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMonitorsResponse, T> g) {
        return obj -> g.apply((ListMonitorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MonitorSummary> monitors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitorsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.monitors(model.monitors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MonitorSummary.Builder> getMonitors() {
            List<MonitorSummary.Builder> result = MonitorSummariesCopier.copyToBuilder(this.monitors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitors(Collection<MonitorSummary.BuilderImpl> monitors) {
            this.monitors = MonitorSummariesCopier.copyFromBuilder(monitors);
        }

        @Override
        public final Builder monitors(Collection<MonitorSummary> monitors) {
            this.monitors = MonitorSummariesCopier.copy(monitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(MonitorSummary ... monitors) {
            this.monitors(Arrays.asList(monitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Consumer<MonitorSummary.Builder> ... monitors) {
            this.monitors(Stream.of(monitors).map(c -> (MonitorSummary)((MonitorSummary.Builder)MonitorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMonitorsResponse build() {
            return new ListMonitorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitorsResponse> {
        public Builder nextToken(String var1);

        public Builder monitors(Collection<MonitorSummary> var1);

        public Builder monitors(MonitorSummary ... var1);

        public Builder monitors(Consumer<MonitorSummary.Builder> ... var1);
    }
}

