/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.WorkerAmountCapability;
import software.amazon.awssdk.services.deadline.model.WorkerAmountCapabilityListCopier;
import software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability;
import software.amazon.awssdk.services.deadline.model.WorkerAttributeCapabilityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerCapabilities> {
    private static final SdkField<List<WorkerAmountCapability>> AMOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amounts").getter(WorkerCapabilities.getter(WorkerCapabilities::amounts)).setter(WorkerCapabilities.setter(Builder::amounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkerAmountCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WorkerAttributeCapability>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(WorkerCapabilities.getter(WorkerCapabilities::attributes)).setter(WorkerCapabilities.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkerAttributeCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNTS_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkerCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<WorkerAmountCapability> amounts;
    private final List<WorkerAttributeCapability> attributes;

    private WorkerCapabilities(BuilderImpl builder) {
        this.amounts = builder.amounts;
        this.attributes = builder.attributes;
    }

    public final boolean hasAmounts() {
        return this.amounts != null && !(this.amounts instanceof SdkAutoConstructList);
    }

    public final List<WorkerAmountCapability> amounts() {
        return this.amounts;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<WorkerAttributeCapability> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmounts() ? this.amounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerCapabilities)) {
            return false;
        }
        WorkerCapabilities other = (WorkerCapabilities)obj;
        return this.hasAmounts() == other.hasAmounts() && Objects.equals(this.amounts(), other.amounts()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerCapabilities").add("Amounts", this.hasAmounts() ? this.amounts() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amounts": {
                return Optional.ofNullable(clazz.cast(this.amounts()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amounts", AMOUNTS_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerCapabilities, T> g) {
        return obj -> g.apply((WorkerCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WorkerAmountCapability> amounts = DefaultSdkAutoConstructList.getInstance();
        private List<WorkerAttributeCapability> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerCapabilities model) {
            this.amounts(model.amounts);
            this.attributes(model.attributes);
        }

        public final List<WorkerAmountCapability.Builder> getAmounts() {
            List<WorkerAmountCapability.Builder> result = WorkerAmountCapabilityListCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<WorkerAmountCapability.BuilderImpl> amounts) {
            this.amounts = WorkerAmountCapabilityListCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<WorkerAmountCapability> amounts) {
            this.amounts = WorkerAmountCapabilityListCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(WorkerAmountCapability ... amounts) {
            this.amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<WorkerAmountCapability.Builder> ... amounts) {
            this.amounts(Stream.of(amounts).map(c -> (WorkerAmountCapability)((WorkerAmountCapability.Builder)WorkerAmountCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WorkerAttributeCapability.Builder> getAttributes() {
            List<WorkerAttributeCapability.Builder> result = WorkerAttributeCapabilityListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<WorkerAttributeCapability.BuilderImpl> attributes) {
            this.attributes = WorkerAttributeCapabilityListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<WorkerAttributeCapability> attributes) {
            this.attributes = WorkerAttributeCapabilityListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(WorkerAttributeCapability ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<WorkerAttributeCapability.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (WorkerAttributeCapability)((WorkerAttributeCapability.Builder)WorkerAttributeCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WorkerCapabilities build() {
            return new WorkerCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerCapabilities> {
        public Builder amounts(Collection<WorkerAmountCapability> var1);

        public Builder amounts(WorkerAmountCapability ... var1);

        public Builder amounts(Consumer<WorkerAmountCapability.Builder> ... var1);

        public Builder attributes(Collection<WorkerAttributeCapability> var1);

        public Builder attributes(WorkerAttributeCapability ... var1);

        public Builder attributes(Consumer<WorkerAttributeCapability.Builder> ... var1);
    }
}

