/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.JobParameterDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobParameterDefinitionsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListJobParameterDefinitionsResponse> {
    private static final SdkField<List<Document>> JOB_PARAMETER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobParameterDefinitions").getter(ListJobParameterDefinitionsResponse.getter(ListJobParameterDefinitionsResponse::jobParameterDefinitions)).setter(ListJobParameterDefinitionsResponse.setter(Builder::jobParameterDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameterDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobParameterDefinitionsResponse.getter(ListJobParameterDefinitionsResponse::nextToken)).setter(ListJobParameterDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_PARAMETER_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListJobParameterDefinitionsResponse.memberNameToFieldInitializer();
    private final List<Document> jobParameterDefinitions;
    private final String nextToken;

    private ListJobParameterDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.jobParameterDefinitions = builder.jobParameterDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobParameterDefinitions() {
        return this.jobParameterDefinitions != null && !(this.jobParameterDefinitions instanceof SdkAutoConstructList);
    }

    public final List<Document> jobParameterDefinitions() {
        return this.jobParameterDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobParameterDefinitions() ? this.jobParameterDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobParameterDefinitionsResponse)) {
            return false;
        }
        ListJobParameterDefinitionsResponse other = (ListJobParameterDefinitionsResponse)((Object)obj);
        return this.hasJobParameterDefinitions() == other.hasJobParameterDefinitions() && Objects.equals(this.jobParameterDefinitions(), other.jobParameterDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobParameterDefinitionsResponse").add("JobParameterDefinitions", this.hasJobParameterDefinitions() ? this.jobParameterDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobParameterDefinitions": {
                return Optional.ofNullable(clazz.cast(this.jobParameterDefinitions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobParameterDefinitions", JOB_PARAMETER_DEFINITIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobParameterDefinitionsResponse, T> g) {
        return obj -> g.apply((ListJobParameterDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<Document> jobParameterDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobParameterDefinitionsResponse model) {
            super(model);
            this.jobParameterDefinitions(model.jobParameterDefinitions);
            this.nextToken(model.nextToken);
        }

        public final Collection<Document> getJobParameterDefinitions() {
            if (this.jobParameterDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobParameterDefinitions;
        }

        public final void setJobParameterDefinitions(Collection<Document> jobParameterDefinitions) {
            this.jobParameterDefinitions = JobParameterDefinitionsCopier.copy(jobParameterDefinitions);
        }

        @Override
        public final Builder jobParameterDefinitions(Collection<Document> jobParameterDefinitions) {
            this.jobParameterDefinitions = JobParameterDefinitionsCopier.copy(jobParameterDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobParameterDefinitions(Document ... jobParameterDefinitions) {
            this.jobParameterDefinitions(Arrays.asList(jobParameterDefinitions));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobParameterDefinitionsResponse build() {
            return new ListJobParameterDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobParameterDefinitionsResponse> {
        public Builder jobParameterDefinitions(Collection<Document> var1);

        public Builder jobParameterDefinitions(Document ... var1);

        public Builder nextToken(String var1);
    }
}

