/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeteredProductSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MeteredProductSummary> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productId").getter(MeteredProductSummary.getter(MeteredProductSummary::productId)).setter(MeteredProductSummary.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productId").build()}).build();
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("family").getter(MeteredProductSummary.getter(MeteredProductSummary::family)).setter(MeteredProductSummary.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendor").getter(MeteredProductSummary.getter(MeteredProductSummary::vendor)).setter(MeteredProductSummary.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(MeteredProductSummary.getter(MeteredProductSummary::port)).setter(MeteredProductSummary.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD, FAMILY_FIELD, VENDOR_FIELD, PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MeteredProductSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String productId;
    private final String family;
    private final String vendor;
    private final Integer port;

    private MeteredProductSummary(BuilderImpl builder) {
        this.productId = builder.productId;
        this.family = builder.family;
        this.vendor = builder.vendor;
        this.port = builder.port;
    }

    public final String productId() {
        return this.productId;
    }

    public final String family() {
        return this.family;
    }

    public final String vendor() {
        return this.vendor;
    }

    public final Integer port() {
        return this.port;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeteredProductSummary)) {
            return false;
        }
        MeteredProductSummary other = (MeteredProductSummary)obj;
        return Objects.equals(this.productId(), other.productId()) && Objects.equals(this.family(), other.family()) && Objects.equals(this.vendor(), other.vendor()) && Objects.equals(this.port(), other.port());
    }

    public final String toString() {
        return ToString.builder((String)"MeteredProductSummary").add("ProductId", (Object)this.productId()).add("Family", (Object)this.family()).add("Vendor", (Object)this.vendor()).add("Port", (Object)this.port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "productId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("productId", PRODUCT_ID_FIELD);
        map.put("family", FAMILY_FIELD);
        map.put("vendor", VENDOR_FIELD);
        map.put("port", PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MeteredProductSummary, T> g) {
        return obj -> g.apply((MeteredProductSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productId;
        private String family;
        private String vendor;
        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(MeteredProductSummary model) {
            this.productId(model.productId);
            this.family(model.family);
            this.vendor(model.vendor);
            this.port(model.port);
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getFamily() {
            return this.family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public MeteredProductSummary build() {
            return new MeteredProductSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MeteredProductSummary> {
        public Builder productId(String var1);

        public Builder family(String var1);

        public Builder vendor(String var1);

        public Builder port(Integer var1);
    }
}

