/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListTasksRequest;
import software.amazon.awssdk.services.deadline.model.ListTasksResponse;
import software.amazon.awssdk.services.deadline.model.TaskSummary;

public class ListTasksIterable
implements SdkIterable<ListTasksResponse> {
    private final DeadlineClient client;
    private final ListTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTasksIterable(DeadlineClient client, ListTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTasksResponseFetcher();
    }

    public Iterator<ListTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TaskSummary> tasks() {
        Function<ListTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTasksResponseFetcher
    implements SyncPageFetcher<ListTasksResponse> {
        private ListTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTasksResponse nextPage(ListTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTasksIterable.this.client.listTasks(ListTasksIterable.this.firstRequest);
            }
            return ListTasksIterable.this.client.listTasks((ListTasksRequest)((Object)ListTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

