/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.StepAmountCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.StepAmountCapability;
import software.amazon.awssdk.services.deadline.model.StepAttributeCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.StepAttributeCapability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepRequiredCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepRequiredCapabilities> {
    private static final SdkField<List<StepAttributeCapability>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(StepRequiredCapabilities.getter(StepRequiredCapabilities::attributes)).setter(StepRequiredCapabilities.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepAttributeCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StepAmountCapability>> AMOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amounts").getter(StepRequiredCapabilities.getter(StepRequiredCapabilities::amounts)).setter(StepRequiredCapabilities.setter(Builder::amounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepAmountCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, AMOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StepRequiredCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StepAttributeCapability> attributes;
    private final List<StepAmountCapability> amounts;

    private StepRequiredCapabilities(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.amounts = builder.amounts;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<StepAttributeCapability> attributes() {
        return this.attributes;
    }

    public final boolean hasAmounts() {
        return this.amounts != null && !(this.amounts instanceof SdkAutoConstructList);
    }

    public final List<StepAmountCapability> amounts() {
        return this.amounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmounts() ? this.amounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepRequiredCapabilities)) {
            return false;
        }
        StepRequiredCapabilities other = (StepRequiredCapabilities)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasAmounts() == other.hasAmounts() && Objects.equals(this.amounts(), other.amounts());
    }

    public final String toString() {
        return ToString.builder((String)"StepRequiredCapabilities").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Amounts", this.hasAmounts() ? this.amounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "amounts": {
                return Optional.ofNullable(clazz.cast(this.amounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("amounts", AMOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepRequiredCapabilities, T> g) {
        return obj -> g.apply((StepRequiredCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StepAttributeCapability> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<StepAmountCapability> amounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StepRequiredCapabilities model) {
            this.attributes(model.attributes);
            this.amounts(model.amounts);
        }

        public final List<StepAttributeCapability.Builder> getAttributes() {
            List<StepAttributeCapability.Builder> result = StepAttributeCapabilitiesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<StepAttributeCapability.BuilderImpl> attributes) {
            this.attributes = StepAttributeCapabilitiesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<StepAttributeCapability> attributes) {
            this.attributes = StepAttributeCapabilitiesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(StepAttributeCapability ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<StepAttributeCapability.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (StepAttributeCapability)((StepAttributeCapability.Builder)StepAttributeCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StepAmountCapability.Builder> getAmounts() {
            List<StepAmountCapability.Builder> result = StepAmountCapabilitiesCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<StepAmountCapability.BuilderImpl> amounts) {
            this.amounts = StepAmountCapabilitiesCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<StepAmountCapability> amounts) {
            this.amounts = StepAmountCapabilitiesCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(StepAmountCapability ... amounts) {
            this.amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<StepAmountCapability.Builder> ... amounts) {
            this.amounts(Stream.of(amounts).map(c -> (StepAmountCapability)((StepAmountCapability.Builder)StepAmountCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StepRequiredCapabilities build() {
            return new StepRequiredCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepRequiredCapabilities> {
        public Builder attributes(Collection<StepAttributeCapability> var1);

        public Builder attributes(StepAttributeCapability ... var1);

        public Builder attributes(Consumer<StepAttributeCapability.Builder> ... var1);

        public Builder amounts(Collection<StepAmountCapability> var1);

        public Builder amounts(StepAmountCapability ... var1);

        public Builder amounts(Consumer<StepAmountCapability.Builder> ... var1);
    }
}

