/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.FarmMember;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse;

public class ListFarmMembersPublisher
implements SdkPublisher<ListFarmMembersResponse> {
    private final DeadlineAsyncClient client;
    private final ListFarmMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFarmMembersPublisher(DeadlineAsyncClient client, ListFarmMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFarmMembersPublisher(DeadlineAsyncClient client, ListFarmMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFarmMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFarmMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FarmMember> members() {
        Function<ListFarmMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFarmMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFarmMembersResponseFetcher
    implements AsyncPageFetcher<ListFarmMembersResponse> {
        private ListFarmMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListFarmMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFarmMembersResponse> nextPage(ListFarmMembersResponse previousPage) {
            if (previousPage == null) {
                return ListFarmMembersPublisher.this.client.listFarmMembers(ListFarmMembersPublisher.this.firstRequest);
            }
            return ListFarmMembersPublisher.this.client.listFarmMembers((ListFarmMembersRequest)((Object)ListFarmMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

