/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.AssignedSession;
import software.amazon.awssdk.services.deadline.model.AssignedSessionsCopier;
import software.amazon.awssdk.services.deadline.model.CancelSessionActionsCopier;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.DesiredWorkerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkerScheduleResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, UpdateWorkerScheduleResponse> {
    private static final SdkField<Map<String, AssignedSession>> ASSIGNED_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("assignedSessions").getter(UpdateWorkerScheduleResponse.getter(UpdateWorkerScheduleResponse::assignedSessions)).setter(UpdateWorkerScheduleResponse.setter(Builder::assignedSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedSessions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssignedSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> CANCEL_SESSION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("cancelSessionActions").getter(UpdateWorkerScheduleResponse.getter(UpdateWorkerScheduleResponse::cancelSessionActions)).setter(UpdateWorkerScheduleResponse.setter(Builder::cancelSessionActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancelSessionActions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> DESIRED_WORKER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredWorkerStatus").getter(UpdateWorkerScheduleResponse.getter(UpdateWorkerScheduleResponse::desiredWorkerStatusAsString)).setter(UpdateWorkerScheduleResponse.setter(Builder::desiredWorkerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredWorkerStatus").build()}).build();
    private static final SdkField<Integer> UPDATE_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("updateIntervalSeconds").getter(UpdateWorkerScheduleResponse.getter(UpdateWorkerScheduleResponse::updateIntervalSeconds)).setter(UpdateWorkerScheduleResponse.setter(Builder::updateIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateIntervalSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNED_SESSIONS_FIELD, CANCEL_SESSION_ACTIONS_FIELD, DESIRED_WORKER_STATUS_FIELD, UPDATE_INTERVAL_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkerScheduleResponse.memberNameToFieldInitializer();
    private final Map<String, AssignedSession> assignedSessions;
    private final Map<String, List<String>> cancelSessionActions;
    private final String desiredWorkerStatus;
    private final Integer updateIntervalSeconds;

    private UpdateWorkerScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.assignedSessions = builder.assignedSessions;
        this.cancelSessionActions = builder.cancelSessionActions;
        this.desiredWorkerStatus = builder.desiredWorkerStatus;
        this.updateIntervalSeconds = builder.updateIntervalSeconds;
    }

    public final boolean hasAssignedSessions() {
        return this.assignedSessions != null && !(this.assignedSessions instanceof SdkAutoConstructMap);
    }

    public final Map<String, AssignedSession> assignedSessions() {
        return this.assignedSessions;
    }

    public final boolean hasCancelSessionActions() {
        return this.cancelSessionActions != null && !(this.cancelSessionActions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> cancelSessionActions() {
        return this.cancelSessionActions;
    }

    public final DesiredWorkerStatus desiredWorkerStatus() {
        return DesiredWorkerStatus.fromValue(this.desiredWorkerStatus);
    }

    public final String desiredWorkerStatusAsString() {
        return this.desiredWorkerStatus;
    }

    public final Integer updateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssignedSessions() ? this.assignedSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCancelSessionActions() ? this.cancelSessionActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWorkerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateIntervalSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkerScheduleResponse)) {
            return false;
        }
        UpdateWorkerScheduleResponse other = (UpdateWorkerScheduleResponse)((Object)obj);
        return this.hasAssignedSessions() == other.hasAssignedSessions() && Objects.equals(this.assignedSessions(), other.assignedSessions()) && this.hasCancelSessionActions() == other.hasCancelSessionActions() && Objects.equals(this.cancelSessionActions(), other.cancelSessionActions()) && Objects.equals(this.desiredWorkerStatusAsString(), other.desiredWorkerStatusAsString()) && Objects.equals(this.updateIntervalSeconds(), other.updateIntervalSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkerScheduleResponse").add("AssignedSessions", this.hasAssignedSessions() ? this.assignedSessions() : null).add("CancelSessionActions", this.hasCancelSessionActions() ? this.cancelSessionActions() : null).add("DesiredWorkerStatus", (Object)this.desiredWorkerStatusAsString()).add("UpdateIntervalSeconds", (Object)this.updateIntervalSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assignedSessions": {
                return Optional.ofNullable(clazz.cast(this.assignedSessions()));
            }
            case "cancelSessionActions": {
                return Optional.ofNullable(clazz.cast(this.cancelSessionActions()));
            }
            case "desiredWorkerStatus": {
                return Optional.ofNullable(clazz.cast(this.desiredWorkerStatusAsString()));
            }
            case "updateIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.updateIntervalSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assignedSessions", ASSIGNED_SESSIONS_FIELD);
        map.put("cancelSessionActions", CANCEL_SESSION_ACTIONS_FIELD);
        map.put("desiredWorkerStatus", DESIRED_WORKER_STATUS_FIELD);
        map.put("updateIntervalSeconds", UPDATE_INTERVAL_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkerScheduleResponse, T> g) {
        return obj -> g.apply((UpdateWorkerScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private Map<String, AssignedSession> assignedSessions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> cancelSessionActions = DefaultSdkAutoConstructMap.getInstance();
        private String desiredWorkerStatus;
        private Integer updateIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkerScheduleResponse model) {
            super(model);
            this.assignedSessions(model.assignedSessions);
            this.cancelSessionActions(model.cancelSessionActions);
            this.desiredWorkerStatus(model.desiredWorkerStatus);
            this.updateIntervalSeconds(model.updateIntervalSeconds);
        }

        public final Map<String, AssignedSession.Builder> getAssignedSessions() {
            Map<String, AssignedSession.Builder> result = AssignedSessionsCopier.copyToBuilder(this.assignedSessions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssignedSessions(Map<String, AssignedSession.BuilderImpl> assignedSessions) {
            this.assignedSessions = AssignedSessionsCopier.copyFromBuilder(assignedSessions);
        }

        @Override
        public final Builder assignedSessions(Map<String, AssignedSession> assignedSessions) {
            this.assignedSessions = AssignedSessionsCopier.copy(assignedSessions);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getCancelSessionActions() {
            if (this.cancelSessionActions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.cancelSessionActions;
        }

        public final void setCancelSessionActions(Map<String, ? extends Collection<String>> cancelSessionActions) {
            this.cancelSessionActions = CancelSessionActionsCopier.copy(cancelSessionActions);
        }

        @Override
        public final Builder cancelSessionActions(Map<String, ? extends Collection<String>> cancelSessionActions) {
            this.cancelSessionActions = CancelSessionActionsCopier.copy(cancelSessionActions);
            return this;
        }

        public final String getDesiredWorkerStatus() {
            return this.desiredWorkerStatus;
        }

        public final void setDesiredWorkerStatus(String desiredWorkerStatus) {
            this.desiredWorkerStatus = desiredWorkerStatus;
        }

        @Override
        public final Builder desiredWorkerStatus(String desiredWorkerStatus) {
            this.desiredWorkerStatus = desiredWorkerStatus;
            return this;
        }

        @Override
        public final Builder desiredWorkerStatus(DesiredWorkerStatus desiredWorkerStatus) {
            this.desiredWorkerStatus(desiredWorkerStatus == null ? null : desiredWorkerStatus.toString());
            return this;
        }

        public final Integer getUpdateIntervalSeconds() {
            return this.updateIntervalSeconds;
        }

        public final void setUpdateIntervalSeconds(Integer updateIntervalSeconds) {
            this.updateIntervalSeconds = updateIntervalSeconds;
        }

        @Override
        public final Builder updateIntervalSeconds(Integer updateIntervalSeconds) {
            this.updateIntervalSeconds = updateIntervalSeconds;
            return this;
        }

        @Override
        public UpdateWorkerScheduleResponse build() {
            return new UpdateWorkerScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkerScheduleResponse> {
        public Builder assignedSessions(Map<String, AssignedSession> var1);

        public Builder cancelSessionActions(Map<String, ? extends Collection<String>> var1);

        public Builder desiredWorkerStatus(String var1);

        public Builder desiredWorkerStatus(DesiredWorkerStatus var1);

        public Builder updateIntervalSeconds(Integer var1);
    }
}

