/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.WorkerSessionSummary;

public class ListSessionsForWorkerIterable
implements SdkIterable<ListSessionsForWorkerResponse> {
    private final DeadlineClient client;
    private final ListSessionsForWorkerRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSessionsForWorkerIterable(DeadlineClient client, ListSessionsForWorkerRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSessionsForWorkerResponseFetcher();
    }

    public Iterator<ListSessionsForWorkerResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkerSessionSummary> sessions() {
        Function<ListSessionsForWorkerResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessions() != null) {
                return response.sessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSessionsForWorkerResponseFetcher
    implements SyncPageFetcher<ListSessionsForWorkerResponse> {
        private ListSessionsForWorkerResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionsForWorkerResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSessionsForWorkerResponse nextPage(ListSessionsForWorkerResponse previousPage) {
            if (previousPage == null) {
                return ListSessionsForWorkerIterable.this.client.listSessionsForWorker(ListSessionsForWorkerIterable.this.firstRequest);
            }
            return ListSessionsForWorkerIterable.this.client.listSessionsForWorker((ListSessionsForWorkerRequest)((Object)ListSessionsForWorkerIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

