/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.SearchTermMatchingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTermFilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchTermFilterExpression> {
    private static final SdkField<String> SEARCH_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchTerm").getter(SearchTermFilterExpression.getter(SearchTermFilterExpression::searchTerm)).setter(SearchTermFilterExpression.setter(Builder::searchTerm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchTerm").build()}).build();
    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchType").getter(SearchTermFilterExpression.getter(SearchTermFilterExpression::matchTypeAsString)).setter(SearchTermFilterExpression.setter(Builder::matchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_TERM_FIELD, MATCH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchTermFilterExpression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String searchTerm;
    private final String matchType;

    private SearchTermFilterExpression(BuilderImpl builder) {
        this.searchTerm = builder.searchTerm;
        this.matchType = builder.matchType;
    }

    public final String searchTerm() {
        return this.searchTerm;
    }

    public final SearchTermMatchingType matchType() {
        return SearchTermMatchingType.fromValue(this.matchType);
    }

    public final String matchTypeAsString() {
        return this.matchType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchTerm());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTermFilterExpression)) {
            return false;
        }
        SearchTermFilterExpression other = (SearchTermFilterExpression)obj;
        return Objects.equals(this.searchTerm(), other.searchTerm()) && Objects.equals(this.matchTypeAsString(), other.matchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTermFilterExpression").add("SearchTerm", (Object)this.searchTerm()).add("MatchType", (Object)this.matchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "searchTerm": {
                return Optional.ofNullable(clazz.cast(this.searchTerm()));
            }
            case "matchType": {
                return Optional.ofNullable(clazz.cast(this.matchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("searchTerm", SEARCH_TERM_FIELD);
        map.put("matchType", MATCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTermFilterExpression, T> g) {
        return obj -> g.apply((SearchTermFilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String searchTerm;
        private String matchType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTermFilterExpression model) {
            this.searchTerm(model.searchTerm);
            this.matchType(model.matchType);
        }

        public final String getSearchTerm() {
            return this.searchTerm;
        }

        public final void setSearchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public final Builder searchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
            return this;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(SearchTermMatchingType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public SearchTermFilterExpression build() {
            return new SearchTermFilterExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchTermFilterExpression> {
        public Builder searchTerm(String var1);

        public Builder matchType(String var1);

        public Builder matchType(SearchTermMatchingType var1);
    }
}

