/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.MeteredProductSummary;

public class ListAvailableMeteredProductsPublisher
implements SdkPublisher<ListAvailableMeteredProductsResponse> {
    private final DeadlineAsyncClient client;
    private final ListAvailableMeteredProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAvailableMeteredProductsPublisher(DeadlineAsyncClient client, ListAvailableMeteredProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAvailableMeteredProductsPublisher(DeadlineAsyncClient client, ListAvailableMeteredProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAvailableMeteredProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAvailableMeteredProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MeteredProductSummary> meteredProducts() {
        Function<ListAvailableMeteredProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.meteredProducts() != null) {
                return response.meteredProducts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAvailableMeteredProductsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAvailableMeteredProductsResponseFetcher
    implements AsyncPageFetcher<ListAvailableMeteredProductsResponse> {
        private ListAvailableMeteredProductsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailableMeteredProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAvailableMeteredProductsResponse> nextPage(ListAvailableMeteredProductsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailableMeteredProductsPublisher.this.client.listAvailableMeteredProducts(ListAvailableMeteredProductsPublisher.this.firstRequest);
            }
            return ListAvailableMeteredProductsPublisher.this.client.listAvailableMeteredProducts((ListAvailableMeteredProductsRequest)((Object)ListAvailableMeteredProductsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

