/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.MeteredProductSummary;

public class ListAvailableMeteredProductsIterable
implements SdkIterable<ListAvailableMeteredProductsResponse> {
    private final DeadlineClient client;
    private final ListAvailableMeteredProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAvailableMeteredProductsIterable(DeadlineClient client, ListAvailableMeteredProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAvailableMeteredProductsResponseFetcher();
    }

    public Iterator<ListAvailableMeteredProductsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MeteredProductSummary> meteredProducts() {
        Function<ListAvailableMeteredProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.meteredProducts() != null) {
                return response.meteredProducts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAvailableMeteredProductsResponseFetcher
    implements SyncPageFetcher<ListAvailableMeteredProductsResponse> {
        private ListAvailableMeteredProductsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailableMeteredProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAvailableMeteredProductsResponse nextPage(ListAvailableMeteredProductsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailableMeteredProductsIterable.this.client.listAvailableMeteredProducts(ListAvailableMeteredProductsIterable.this.firstRequest);
            }
            return ListAvailableMeteredProductsIterable.this.client.listAvailableMeteredProducts((ListAvailableMeteredProductsRequest)((Object)ListAvailableMeteredProductsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

