/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinitionSummary;
import software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinitionSummary;
import software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary;
import software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinitionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionActionDefinitionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionActionDefinitionSummary> {
    private static final SdkField<EnvironmentEnterSessionActionDefinitionSummary> ENV_ENTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("envEnter").getter(SessionActionDefinitionSummary.getter(SessionActionDefinitionSummary::envEnter)).setter(SessionActionDefinitionSummary.setter(Builder::envEnter)).constructor(EnvironmentEnterSessionActionDefinitionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envEnter").build()}).build();
    private static final SdkField<EnvironmentExitSessionActionDefinitionSummary> ENV_EXIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("envExit").getter(SessionActionDefinitionSummary.getter(SessionActionDefinitionSummary::envExit)).setter(SessionActionDefinitionSummary.setter(Builder::envExit)).constructor(EnvironmentExitSessionActionDefinitionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envExit").build()}).build();
    private static final SdkField<TaskRunSessionActionDefinitionSummary> TASK_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskRun").getter(SessionActionDefinitionSummary.getter(SessionActionDefinitionSummary::taskRun)).setter(SessionActionDefinitionSummary.setter(Builder::taskRun)).constructor(TaskRunSessionActionDefinitionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRun").build()}).build();
    private static final SdkField<SyncInputJobAttachmentsSessionActionDefinitionSummary> SYNC_INPUT_JOB_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("syncInputJobAttachments").getter(SessionActionDefinitionSummary.getter(SessionActionDefinitionSummary::syncInputJobAttachments)).setter(SessionActionDefinitionSummary.setter(Builder::syncInputJobAttachments)).constructor(SyncInputJobAttachmentsSessionActionDefinitionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncInputJobAttachments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENV_ENTER_FIELD, ENV_EXIT_FIELD, TASK_RUN_FIELD, SYNC_INPUT_JOB_ATTACHMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionActionDefinitionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EnvironmentEnterSessionActionDefinitionSummary envEnter;
    private final EnvironmentExitSessionActionDefinitionSummary envExit;
    private final TaskRunSessionActionDefinitionSummary taskRun;
    private final SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments;
    private final Type type;

    private SessionActionDefinitionSummary(BuilderImpl builder) {
        this.envEnter = builder.envEnter;
        this.envExit = builder.envExit;
        this.taskRun = builder.taskRun;
        this.syncInputJobAttachments = builder.syncInputJobAttachments;
        this.type = builder.type;
    }

    public final EnvironmentEnterSessionActionDefinitionSummary envEnter() {
        return this.envEnter;
    }

    public final EnvironmentExitSessionActionDefinitionSummary envExit() {
        return this.envExit;
    }

    public final TaskRunSessionActionDefinitionSummary taskRun() {
        return this.taskRun;
    }

    public final SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments() {
        return this.syncInputJobAttachments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.envEnter());
        hashCode = 31 * hashCode + Objects.hashCode(this.envExit());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncInputJobAttachments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionActionDefinitionSummary)) {
            return false;
        }
        SessionActionDefinitionSummary other = (SessionActionDefinitionSummary)obj;
        return Objects.equals(this.envEnter(), other.envEnter()) && Objects.equals(this.envExit(), other.envExit()) && Objects.equals(this.taskRun(), other.taskRun()) && Objects.equals(this.syncInputJobAttachments(), other.syncInputJobAttachments());
    }

    public final String toString() {
        return ToString.builder((String)"SessionActionDefinitionSummary").add("EnvEnter", (Object)this.envEnter()).add("EnvExit", (Object)this.envExit()).add("TaskRun", (Object)this.taskRun()).add("SyncInputJobAttachments", (Object)this.syncInputJobAttachments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "envEnter": {
                return Optional.ofNullable(clazz.cast(this.envEnter()));
            }
            case "envExit": {
                return Optional.ofNullable(clazz.cast(this.envExit()));
            }
            case "taskRun": {
                return Optional.ofNullable(clazz.cast(this.taskRun()));
            }
            case "syncInputJobAttachments": {
                return Optional.ofNullable(clazz.cast(this.syncInputJobAttachments()));
            }
        }
        return Optional.empty();
    }

    public static SessionActionDefinitionSummary fromEnvEnter(EnvironmentEnterSessionActionDefinitionSummary envEnter) {
        return (SessionActionDefinitionSummary)SessionActionDefinitionSummary.builder().envEnter(envEnter).build();
    }

    public static SessionActionDefinitionSummary fromEnvEnter(Consumer<EnvironmentEnterSessionActionDefinitionSummary.Builder> envEnter) {
        EnvironmentEnterSessionActionDefinitionSummary.Builder builder = EnvironmentEnterSessionActionDefinitionSummary.builder();
        envEnter.accept(builder);
        return SessionActionDefinitionSummary.fromEnvEnter((EnvironmentEnterSessionActionDefinitionSummary)builder.build());
    }

    public static SessionActionDefinitionSummary fromEnvExit(EnvironmentExitSessionActionDefinitionSummary envExit) {
        return (SessionActionDefinitionSummary)SessionActionDefinitionSummary.builder().envExit(envExit).build();
    }

    public static SessionActionDefinitionSummary fromEnvExit(Consumer<EnvironmentExitSessionActionDefinitionSummary.Builder> envExit) {
        EnvironmentExitSessionActionDefinitionSummary.Builder builder = EnvironmentExitSessionActionDefinitionSummary.builder();
        envExit.accept(builder);
        return SessionActionDefinitionSummary.fromEnvExit((EnvironmentExitSessionActionDefinitionSummary)builder.build());
    }

    public static SessionActionDefinitionSummary fromTaskRun(TaskRunSessionActionDefinitionSummary taskRun) {
        return (SessionActionDefinitionSummary)SessionActionDefinitionSummary.builder().taskRun(taskRun).build();
    }

    public static SessionActionDefinitionSummary fromTaskRun(Consumer<TaskRunSessionActionDefinitionSummary.Builder> taskRun) {
        TaskRunSessionActionDefinitionSummary.Builder builder = TaskRunSessionActionDefinitionSummary.builder();
        taskRun.accept(builder);
        return SessionActionDefinitionSummary.fromTaskRun((TaskRunSessionActionDefinitionSummary)builder.build());
    }

    public static SessionActionDefinitionSummary fromSyncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments) {
        return (SessionActionDefinitionSummary)SessionActionDefinitionSummary.builder().syncInputJobAttachments(syncInputJobAttachments).build();
    }

    public static SessionActionDefinitionSummary fromSyncInputJobAttachments(Consumer<SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder> syncInputJobAttachments) {
        SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder builder = SyncInputJobAttachmentsSessionActionDefinitionSummary.builder();
        syncInputJobAttachments.accept(builder);
        return SessionActionDefinitionSummary.fromSyncInputJobAttachments((SyncInputJobAttachmentsSessionActionDefinitionSummary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("envEnter", ENV_ENTER_FIELD);
        map.put("envExit", ENV_EXIT_FIELD);
        map.put("taskRun", TASK_RUN_FIELD);
        map.put("syncInputJobAttachments", SYNC_INPUT_JOB_ATTACHMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionActionDefinitionSummary, T> g) {
        return obj -> g.apply((SessionActionDefinitionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ENV_ENTER,
        ENV_EXIT,
        TASK_RUN,
        SYNC_INPUT_JOB_ATTACHMENTS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EnvironmentEnterSessionActionDefinitionSummary envEnter;
        private EnvironmentExitSessionActionDefinitionSummary envExit;
        private TaskRunSessionActionDefinitionSummary taskRun;
        private SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionActionDefinitionSummary model) {
            this.envEnter(model.envEnter);
            this.envExit(model.envExit);
            this.taskRun(model.taskRun);
            this.syncInputJobAttachments(model.syncInputJobAttachments);
        }

        public final EnvironmentEnterSessionActionDefinitionSummary.Builder getEnvEnter() {
            return this.envEnter != null ? this.envEnter.toBuilder() : null;
        }

        public final void setEnvEnter(EnvironmentEnterSessionActionDefinitionSummary.BuilderImpl envEnter) {
            EnvironmentEnterSessionActionDefinitionSummary oldValue = this.envEnter;
            this.envEnter = envEnter != null ? envEnter.build() : null;
            this.handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
        }

        @Override
        public final Builder envEnter(EnvironmentEnterSessionActionDefinitionSummary envEnter) {
            EnvironmentEnterSessionActionDefinitionSummary oldValue = this.envEnter;
            this.envEnter = envEnter;
            this.handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
            return this;
        }

        public final EnvironmentExitSessionActionDefinitionSummary.Builder getEnvExit() {
            return this.envExit != null ? this.envExit.toBuilder() : null;
        }

        public final void setEnvExit(EnvironmentExitSessionActionDefinitionSummary.BuilderImpl envExit) {
            EnvironmentExitSessionActionDefinitionSummary oldValue = this.envExit;
            this.envExit = envExit != null ? envExit.build() : null;
            this.handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
        }

        @Override
        public final Builder envExit(EnvironmentExitSessionActionDefinitionSummary envExit) {
            EnvironmentExitSessionActionDefinitionSummary oldValue = this.envExit;
            this.envExit = envExit;
            this.handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
            return this;
        }

        public final TaskRunSessionActionDefinitionSummary.Builder getTaskRun() {
            return this.taskRun != null ? this.taskRun.toBuilder() : null;
        }

        public final void setTaskRun(TaskRunSessionActionDefinitionSummary.BuilderImpl taskRun) {
            TaskRunSessionActionDefinitionSummary oldValue = this.taskRun;
            this.taskRun = taskRun != null ? taskRun.build() : null;
            this.handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
        }

        @Override
        public final Builder taskRun(TaskRunSessionActionDefinitionSummary taskRun) {
            TaskRunSessionActionDefinitionSummary oldValue = this.taskRun;
            this.taskRun = taskRun;
            this.handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
            return this;
        }

        public final SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder getSyncInputJobAttachments() {
            return this.syncInputJobAttachments != null ? this.syncInputJobAttachments.toBuilder() : null;
        }

        public final void setSyncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary.BuilderImpl syncInputJobAttachments) {
            SyncInputJobAttachmentsSessionActionDefinitionSummary oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments != null ? syncInputJobAttachments.build() : null;
            this.handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
        }

        @Override
        public final Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments) {
            SyncInputJobAttachmentsSessionActionDefinitionSummary oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments;
            this.handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
            return this;
        }

        public SessionActionDefinitionSummary build() {
            return new SessionActionDefinitionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionActionDefinitionSummary> {
        public Builder envEnter(EnvironmentEnterSessionActionDefinitionSummary var1);

        default public Builder envEnter(Consumer<EnvironmentEnterSessionActionDefinitionSummary.Builder> envEnter) {
            return this.envEnter((EnvironmentEnterSessionActionDefinitionSummary)((EnvironmentEnterSessionActionDefinitionSummary.Builder)EnvironmentEnterSessionActionDefinitionSummary.builder().applyMutation(envEnter)).build());
        }

        public Builder envExit(EnvironmentExitSessionActionDefinitionSummary var1);

        default public Builder envExit(Consumer<EnvironmentExitSessionActionDefinitionSummary.Builder> envExit) {
            return this.envExit((EnvironmentExitSessionActionDefinitionSummary)((EnvironmentExitSessionActionDefinitionSummary.Builder)EnvironmentExitSessionActionDefinitionSummary.builder().applyMutation(envExit)).build());
        }

        public Builder taskRun(TaskRunSessionActionDefinitionSummary var1);

        default public Builder taskRun(Consumer<TaskRunSessionActionDefinitionSummary.Builder> taskRun) {
            return this.taskRun((TaskRunSessionActionDefinitionSummary)((TaskRunSessionActionDefinitionSummary.Builder)TaskRunSessionActionDefinitionSummary.builder().applyMutation(taskRun)).build());
        }

        public Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary var1);

        default public Builder syncInputJobAttachments(Consumer<SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder> syncInputJobAttachments) {
            return this.syncInputJobAttachments((SyncInputJobAttachmentsSessionActionDefinitionSummary)((SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder)SyncInputJobAttachmentsSessionActionDefinitionSummary.builder().applyMutation(syncInputJobAttachments)).build());
        }
    }
}

