/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.TaskParameterValue;
import software.amazon.awssdk.services.deadline.model.TaskParametersCopier;
import software.amazon.awssdk.services.deadline.model.TaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskSearchSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(TaskSearchSummary.getter(TaskSearchSummary::taskId)).setter(TaskSearchSummary.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(TaskSearchSummary.getter(TaskSearchSummary::stepId)).setter(TaskSearchSummary.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(TaskSearchSummary.getter(TaskSearchSummary::jobId)).setter(TaskSearchSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(TaskSearchSummary.getter(TaskSearchSummary::queueId)).setter(TaskSearchSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runStatus").getter(TaskSearchSummary.getter(TaskSearchSummary::runStatusAsString)).setter(TaskSearchSummary.setter(Builder::runStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStatus").build()}).build();
    private static final SdkField<String> TARGET_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetRunStatus").getter(TaskSearchSummary.getter(TaskSearchSummary::targetRunStatusAsString)).setter(TaskSearchSummary.setter(Builder::targetRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRunStatus").build()}).build();
    private static final SdkField<Map<String, TaskParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(TaskSearchSummary.getter(TaskSearchSummary::parameters)).setter(TaskSearchSummary.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> FAILURE_RETRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failureRetryCount").getter(TaskSearchSummary.getter(TaskSearchSummary::failureRetryCount)).setter(TaskSearchSummary.setter(Builder::failureRetryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureRetryCount").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(TaskSearchSummary.getter(TaskSearchSummary::startedAt)).setter(TaskSearchSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(TaskSearchSummary.getter(TaskSearchSummary::endedAt)).setter(TaskSearchSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, STEP_ID_FIELD, JOB_ID_FIELD, QUEUE_ID_FIELD, RUN_STATUS_FIELD, TARGET_RUN_STATUS_FIELD, PARAMETERS_FIELD, FAILURE_RETRY_COUNT_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskSearchSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String stepId;
    private final String jobId;
    private final String queueId;
    private final String runStatus;
    private final String targetRunStatus;
    private final Map<String, TaskParameterValue> parameters;
    private final Integer failureRetryCount;
    private final Instant startedAt;
    private final Instant endedAt;

    private TaskSearchSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.stepId = builder.stepId;
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.runStatus = builder.runStatus;
        this.targetRunStatus = builder.targetRunStatus;
        this.parameters = builder.parameters;
        this.failureRetryCount = builder.failureRetryCount;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final TaskRunStatus runStatus() {
        return TaskRunStatus.fromValue(this.runStatus);
    }

    public final String runStatusAsString() {
        return this.runStatus;
    }

    public final TaskTargetRunStatus targetRunStatus() {
        return TaskTargetRunStatus.fromValue(this.targetRunStatus);
    }

    public final String targetRunStatusAsString() {
        return this.targetRunStatus;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, TaskParameterValue> parameters() {
        return this.parameters;
    }

    public final Integer failureRetryCount() {
        return this.failureRetryCount;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSearchSummary)) {
            return false;
        }
        TaskSearchSummary other = (TaskSearchSummary)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.runStatusAsString(), other.runStatusAsString()) && Objects.equals(this.targetRunStatusAsString(), other.targetRunStatusAsString()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.failureRetryCount(), other.failureRetryCount()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt());
    }

    public final String toString() {
        return ToString.builder((String)"TaskSearchSummary").add("TaskId", (Object)this.taskId()).add("StepId", (Object)this.stepId()).add("JobId", (Object)this.jobId()).add("QueueId", (Object)this.queueId()).add("RunStatus", (Object)this.runStatusAsString()).add("TargetRunStatus", (Object)this.targetRunStatusAsString()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("FailureRetryCount", (Object)this.failureRetryCount()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "runStatus": {
                return Optional.ofNullable(clazz.cast(this.runStatusAsString()));
            }
            case "targetRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetRunStatusAsString()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "failureRetryCount": {
                return Optional.ofNullable(clazz.cast(this.failureRetryCount()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("stepId", STEP_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("runStatus", RUN_STATUS_FIELD);
        map.put("targetRunStatus", TARGET_RUN_STATUS_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("failureRetryCount", FAILURE_RETRY_COUNT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskSearchSummary, T> g) {
        return obj -> g.apply((TaskSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String stepId;
        private String jobId;
        private String queueId;
        private String runStatus;
        private String targetRunStatus;
        private Map<String, TaskParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer failureRetryCount;
        private Instant startedAt;
        private Instant endedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSearchSummary model) {
            this.taskId(model.taskId);
            this.stepId(model.stepId);
            this.jobId(model.jobId);
            this.queueId(model.queueId);
            this.runStatus(model.runStatus);
            this.targetRunStatus(model.targetRunStatus);
            this.parameters(model.parameters);
            this.failureRetryCount(model.failureRetryCount);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getRunStatus() {
            return this.runStatus;
        }

        public final void setRunStatus(String runStatus) {
            this.runStatus = runStatus;
        }

        @Override
        public final Builder runStatus(String runStatus) {
            this.runStatus = runStatus;
            return this;
        }

        @Override
        public final Builder runStatus(TaskRunStatus runStatus) {
            this.runStatus(runStatus == null ? null : runStatus.toString());
            return this;
        }

        public final String getTargetRunStatus() {
            return this.targetRunStatus;
        }

        public final void setTargetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
        }

        @Override
        public final Builder targetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
            return this;
        }

        @Override
        public final Builder targetRunStatus(TaskTargetRunStatus targetRunStatus) {
            this.targetRunStatus(targetRunStatus == null ? null : targetRunStatus.toString());
            return this;
        }

        public final Map<String, TaskParameterValue.Builder> getParameters() {
            Map<String, TaskParameterValue.Builder> result = TaskParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TaskParameterValue.BuilderImpl> parameters) {
            this.parameters = TaskParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TaskParameterValue> parameters) {
            this.parameters = TaskParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getFailureRetryCount() {
            return this.failureRetryCount;
        }

        public final void setFailureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
        }

        @Override
        public final Builder failureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public TaskSearchSummary build() {
            return new TaskSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskSearchSummary> {
        public Builder taskId(String var1);

        public Builder stepId(String var1);

        public Builder jobId(String var1);

        public Builder queueId(String var1);

        public Builder runStatus(String var1);

        public Builder runStatus(TaskRunStatus var1);

        public Builder targetRunStatus(String var1);

        public Builder targetRunStatus(TaskTargetRunStatus var1);

        public Builder parameters(Map<String, TaskParameterValue> var1);

        public Builder failureRetryCount(Integer var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);
    }
}

