/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.SessionLifecycleTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSessionRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateSessionRequest.getter(UpdateSessionRequest::clientToken)).setter(UpdateSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateSessionRequest.getter(UpdateSessionRequest::farmId)).setter(UpdateSessionRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(UpdateSessionRequest.getter(UpdateSessionRequest::queueId)).setter(UpdateSessionRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(UpdateSessionRequest.getter(UpdateSessionRequest::jobId)).setter(UpdateSessionRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateSessionRequest.getter(UpdateSessionRequest::sessionId)).setter(UpdateSessionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> TARGET_LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetLifecycleStatus").getter(UpdateSessionRequest.getter(UpdateSessionRequest::targetLifecycleStatusAsString)).setter(UpdateSessionRequest.setter(Builder::targetLifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLifecycleStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, FARM_ID_FIELD, QUEUE_ID_FIELD, JOB_ID_FIELD, SESSION_ID_FIELD, TARGET_LIFECYCLE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
            this.put("farmId", FARM_ID_FIELD);
            this.put("queueId", QUEUE_ID_FIELD);
            this.put("jobId", JOB_ID_FIELD);
            this.put("sessionId", SESSION_ID_FIELD);
            this.put("targetLifecycleStatus", TARGET_LIFECYCLE_STATUS_FIELD);
        }
    });
    private final String clientToken;
    private final String farmId;
    private final String queueId;
    private final String jobId;
    private final String sessionId;
    private final String targetLifecycleStatus;

    private UpdateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
        this.sessionId = builder.sessionId;
        this.targetLifecycleStatus = builder.targetLifecycleStatus;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final SessionLifecycleTargetStatus targetLifecycleStatus() {
        return SessionLifecycleTargetStatus.fromValue(this.targetLifecycleStatus);
    }

    public final String targetLifecycleStatusAsString() {
        return this.targetLifecycleStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLifecycleStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionRequest)) {
            return false;
        }
        UpdateSessionRequest other = (UpdateSessionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.targetLifecycleStatusAsString(), other.targetLifecycleStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSessionRequest").add("ClientToken", (Object)this.clientToken()).add("FarmId", (Object)this.farmId()).add("QueueId", (Object)this.queueId()).add("JobId", (Object)this.jobId()).add("SessionId", (Object)this.sessionId()).add("TargetLifecycleStatus", (Object)this.targetLifecycleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "targetLifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.targetLifecycleStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionRequest, T> g) {
        return obj -> g.apply((UpdateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String farmId;
        private String queueId;
        private String jobId;
        private String sessionId;
        private String targetLifecycleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.farmId(model.farmId);
            this.queueId(model.queueId);
            this.jobId(model.jobId);
            this.sessionId(model.sessionId);
            this.targetLifecycleStatus(model.targetLifecycleStatus);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTargetLifecycleStatus() {
            return this.targetLifecycleStatus;
        }

        public final void setTargetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
        }

        @Override
        public final Builder targetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
            return this;
        }

        @Override
        public final Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus) {
            this.targetLifecycleStatus(targetLifecycleStatus == null ? null : targetLifecycleStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSessionRequest build() {
            return new UpdateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSessionRequest> {
        public Builder clientToken(String var1);

        public Builder farmId(String var1);

        public Builder queueId(String var1);

        public Builder jobId(String var1);

        public Builder sessionId(String var1);

        public Builder targetLifecycleStatus(String var1);

        public Builder targetLifecycleStatus(SessionLifecycleTargetStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

