/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.FileSystemLocation;
import software.amazon.awssdk.services.deadline.model.FileSystemLocationsListCopier;
import software.amazon.awssdk.services.deadline.model.StorageProfileOperatingSystemFamily;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStorageProfileForQueueResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetStorageProfileForQueueResponse> {
    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageProfileId").getter(GetStorageProfileForQueueResponse.getter(GetStorageProfileForQueueResponse::storageProfileId)).setter(GetStorageProfileForQueueResponse.setter(Builder::storageProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetStorageProfileForQueueResponse.getter(GetStorageProfileForQueueResponse::displayName)).setter(GetStorageProfileForQueueResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osFamily").getter(GetStorageProfileForQueueResponse.getter(GetStorageProfileForQueueResponse::osFamilyAsString)).setter(GetStorageProfileForQueueResponse.setter(Builder::osFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()}).build();
    private static final SdkField<List<FileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocations").getter(GetStorageProfileForQueueResponse.getter(GetStorageProfileForQueueResponse::fileSystemLocations)).setter(GetStorageProfileForQueueResponse.setter(Builder::fileSystemLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_PROFILE_ID_FIELD, DISPLAY_NAME_FIELD, OS_FAMILY_FIELD, FILE_SYSTEM_LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("storageProfileId", STORAGE_PROFILE_ID_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("osFamily", OS_FAMILY_FIELD);
            this.put("fileSystemLocations", FILE_SYSTEM_LOCATIONS_FIELD);
        }
    });
    private final String storageProfileId;
    private final String displayName;
    private final String osFamily;
    private final List<FileSystemLocation> fileSystemLocations;

    private GetStorageProfileForQueueResponse(BuilderImpl builder) {
        super(builder);
        this.storageProfileId = builder.storageProfileId;
        this.displayName = builder.displayName;
        this.osFamily = builder.osFamily;
        this.fileSystemLocations = builder.fileSystemLocations;
    }

    public final String storageProfileId() {
        return this.storageProfileId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final StorageProfileOperatingSystemFamily osFamily() {
        return StorageProfileOperatingSystemFamily.fromValue(this.osFamily);
    }

    public final String osFamilyAsString() {
        return this.osFamily;
    }

    public final boolean hasFileSystemLocations() {
        return this.fileSystemLocations != null && !(this.fileSystemLocations instanceof SdkAutoConstructList);
    }

    public final List<FileSystemLocation> fileSystemLocations() {
        return this.fileSystemLocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocations() ? this.fileSystemLocations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageProfileForQueueResponse)) {
            return false;
        }
        GetStorageProfileForQueueResponse other = (GetStorageProfileForQueueResponse)((Object)obj);
        return Objects.equals(this.storageProfileId(), other.storageProfileId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.osFamilyAsString(), other.osFamilyAsString()) && this.hasFileSystemLocations() == other.hasFileSystemLocations() && Objects.equals(this.fileSystemLocations(), other.fileSystemLocations());
    }

    public final String toString() {
        return ToString.builder((String)"GetStorageProfileForQueueResponse").add("StorageProfileId", (Object)this.storageProfileId()).add("DisplayName", (Object)this.displayName()).add("OsFamily", (Object)this.osFamilyAsString()).add("FileSystemLocations", (Object)(this.fileSystemLocations() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageProfileId": {
                return Optional.ofNullable(clazz.cast(this.storageProfileId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "osFamily": {
                return Optional.ofNullable(clazz.cast(this.osFamilyAsString()));
            }
            case "fileSystemLocations": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetStorageProfileForQueueResponse, T> g) {
        return obj -> g.apply((GetStorageProfileForQueueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String storageProfileId;
        private String displayName;
        private String osFamily;
        private List<FileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetStorageProfileForQueueResponse model) {
            super(model);
            this.storageProfileId(model.storageProfileId);
            this.displayName(model.displayName);
            this.osFamily(model.osFamily);
            this.fileSystemLocations(model.fileSystemLocations);
        }

        public final String getStorageProfileId() {
            return this.storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getOsFamily() {
            return this.osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(StorageProfileOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final List<FileSystemLocation.Builder> getFileSystemLocations() {
            List<FileSystemLocation.Builder> result = FileSystemLocationsListCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<FileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(FileSystemLocation ... fileSystemLocations) {
            this.fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<FileSystemLocation.Builder> ... fileSystemLocations) {
            this.fileSystemLocations(Stream.of(fileSystemLocations).map(c -> (FileSystemLocation)((FileSystemLocation.Builder)FileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetStorageProfileForQueueResponse build() {
            return new GetStorageProfileForQueueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStorageProfileForQueueResponse> {
        public Builder storageProfileId(String var1);

        public Builder displayName(String var1);

        public Builder osFamily(String var1);

        public Builder osFamily(StorageProfileOperatingSystemFamily var1);

        public Builder fileSystemLocations(Collection<FileSystemLocation> var1);

        public Builder fileSystemLocations(FileSystemLocation ... var1);

        public Builder fileSystemLocations(Consumer<FileSystemLocation.Builder> ... var1);
    }
}

