/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse;
import software.amazon.awssdk.services.deadline.model.StepDependency;

public class ListStepDependenciesPublisher
implements SdkPublisher<ListStepDependenciesResponse> {
    private final DeadlineAsyncClient client;
    private final ListStepDependenciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStepDependenciesPublisher(DeadlineAsyncClient client, ListStepDependenciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStepDependenciesPublisher(DeadlineAsyncClient client, ListStepDependenciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStepDependenciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStepDependenciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StepDependency> dependencies() {
        Function<ListStepDependenciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dependencies() != null) {
                return response.dependencies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStepDependenciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStepDependenciesResponseFetcher
    implements AsyncPageFetcher<ListStepDependenciesResponse> {
        private ListStepDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListStepDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStepDependenciesResponse> nextPage(ListStepDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListStepDependenciesPublisher.this.client.listStepDependencies(ListStepDependenciesPublisher.this.firstRequest);
            }
            return ListStepDependenciesPublisher.this.client.listStepDependencies((ListStepDependenciesRequest)((Object)ListStepDependenciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

