/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummariesCopier;
import software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueueFleetAssociationsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListQueueFleetAssociationsResponse> {
    private static final SdkField<List<QueueFleetAssociationSummary>> QUEUE_FLEET_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queueFleetAssociations").getter(ListQueueFleetAssociationsResponse.getter(ListQueueFleetAssociationsResponse::queueFleetAssociations)).setter(ListQueueFleetAssociationsResponse.setter(Builder::queueFleetAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueFleetAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueueFleetAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListQueueFleetAssociationsResponse.getter(ListQueueFleetAssociationsResponse::nextToken)).setter(ListQueueFleetAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_FLEET_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<QueueFleetAssociationSummary> queueFleetAssociations;
    private final String nextToken;

    private ListQueueFleetAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.queueFleetAssociations = builder.queueFleetAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasQueueFleetAssociations() {
        return this.queueFleetAssociations != null && !(this.queueFleetAssociations instanceof SdkAutoConstructList);
    }

    public final List<QueueFleetAssociationSummary> queueFleetAssociations() {
        return this.queueFleetAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueFleetAssociations() ? this.queueFleetAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueFleetAssociationsResponse)) {
            return false;
        }
        ListQueueFleetAssociationsResponse other = (ListQueueFleetAssociationsResponse)((Object)obj);
        return this.hasQueueFleetAssociations() == other.hasQueueFleetAssociations() && Objects.equals(this.queueFleetAssociations(), other.queueFleetAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueueFleetAssociationsResponse").add("QueueFleetAssociations", this.hasQueueFleetAssociations() ? this.queueFleetAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queueFleetAssociations": {
                return Optional.ofNullable(clazz.cast(this.queueFleetAssociations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueueFleetAssociationsResponse, T> g) {
        return obj -> g.apply((ListQueueFleetAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<QueueFleetAssociationSummary> queueFleetAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueFleetAssociationsResponse model) {
            super(model);
            this.queueFleetAssociations(model.queueFleetAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<QueueFleetAssociationSummary.Builder> getQueueFleetAssociations() {
            List<QueueFleetAssociationSummary.Builder> result = QueueFleetAssociationSummariesCopier.copyToBuilder(this.queueFleetAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueueFleetAssociations(Collection<QueueFleetAssociationSummary.BuilderImpl> queueFleetAssociations) {
            this.queueFleetAssociations = QueueFleetAssociationSummariesCopier.copyFromBuilder(queueFleetAssociations);
        }

        @Override
        public final Builder queueFleetAssociations(Collection<QueueFleetAssociationSummary> queueFleetAssociations) {
            this.queueFleetAssociations = QueueFleetAssociationSummariesCopier.copy(queueFleetAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueFleetAssociations(QueueFleetAssociationSummary ... queueFleetAssociations) {
            this.queueFleetAssociations(Arrays.asList(queueFleetAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueFleetAssociations(Consumer<QueueFleetAssociationSummary.Builder> ... queueFleetAssociations) {
            this.queueFleetAssociations(Stream.of(queueFleetAssociations).map(c -> (QueueFleetAssociationSummary)((QueueFleetAssociationSummary.Builder)QueueFleetAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueueFleetAssociationsResponse build() {
            return new ListQueueFleetAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueueFleetAssociationsResponse> {
        public Builder queueFleetAssociations(Collection<QueueFleetAssociationSummary> var1);

        public Builder queueFleetAssociations(QueueFleetAssociationSummary ... var1);

        public Builder queueFleetAssociations(Consumer<QueueFleetAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

