/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.MembershipLevel;
import software.amazon.awssdk.services.deadline.model.PrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateMemberToJobRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, AssociateMemberToJobRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(AssociateMemberToJobRequest.getter(AssociateMemberToJobRequest::farmId)).setter(AssociateMemberToJobRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityStoreId").getter(AssociateMemberToJobRequest.getter(AssociateMemberToJobRequest::identityStoreId)).setter(AssociateMemberToJobRequest.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityStoreId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(AssociateMemberToJobRequest.getter(AssociateMemberToJobRequest::jobId)).setter(AssociateMemberToJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipLevel").getter(AssociateMemberToJobRequest.getter(AssociateMemberToJobRequest::membershipLevelAsString)).setter(AssociateMemberToJobRequest.setter(Builder::membershipLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipLevel").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(AssociateMemberToJobRequest.getter(AssociateMemberToJobRequest::principalId)).setter(AssociateMemberToJobRequest.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalId").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalType").getter(AssociateMemberToJobRequest.getter(AssociateMemberToJobRequest::principalTypeAsString)).setter(AssociateMemberToJobRequest.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalType").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(AssociateMemberToJobRequest.getter(AssociateMemberToJobRequest::queueId)).setter(AssociateMemberToJobRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, IDENTITY_STORE_ID_FIELD, JOB_ID_FIELD, MEMBERSHIP_LEVEL_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, QUEUE_ID_FIELD));
    private final String farmId;
    private final String identityStoreId;
    private final String jobId;
    private final String membershipLevel;
    private final String principalId;
    private final String principalType;
    private final String queueId;

    private AssociateMemberToJobRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.identityStoreId = builder.identityStoreId;
        this.jobId = builder.jobId;
        this.membershipLevel = builder.membershipLevel;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.queueId = builder.queueId;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final MembershipLevel membershipLevel() {
        return MembershipLevel.fromValue(this.membershipLevel);
    }

    public final String membershipLevelAsString() {
        return this.membershipLevel;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    public final String queueId() {
        return this.queueId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateMemberToJobRequest)) {
            return false;
        }
        AssociateMemberToJobRequest other = (AssociateMemberToJobRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.membershipLevelAsString(), other.membershipLevelAsString()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString()) && Objects.equals(this.queueId(), other.queueId());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateMemberToJobRequest").add("FarmId", (Object)this.farmId()).add("IdentityStoreId", (Object)this.identityStoreId()).add("JobId", (Object)this.jobId()).add("MembershipLevel", (Object)this.membershipLevelAsString()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalTypeAsString()).add("QueueId", (Object)this.queueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "identityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "membershipLevel": {
                return Optional.ofNullable(clazz.cast(this.membershipLevelAsString()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "principalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateMemberToJobRequest, T> g) {
        return obj -> g.apply((AssociateMemberToJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private String identityStoreId;
        private String jobId;
        private String membershipLevel;
        private String principalId;
        private String principalType;
        private String queueId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateMemberToJobRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.identityStoreId(model.identityStoreId);
            this.jobId(model.jobId);
            this.membershipLevel(model.membershipLevel);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
            this.queueId(model.queueId);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getMembershipLevel() {
            return this.membershipLevel;
        }

        public final void setMembershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
        }

        @Override
        public final Builder membershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
            return this;
        }

        @Override
        public final Builder membershipLevel(MembershipLevel membershipLevel) {
            this.membershipLevel(membershipLevel == null ? null : membershipLevel.toString());
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateMemberToJobRequest build() {
            return new AssociateMemberToJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateMemberToJobRequest> {
        public Builder farmId(String var1);

        public Builder identityStoreId(String var1);

        public Builder jobId(String var1);

        public Builder membershipLevel(String var1);

        public Builder membershipLevel(MembershipLevel var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder queueId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

