/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PathFormat {
    WINDOWS("windows"),
    POSIX("posix"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PathFormat> VALUE_MAP;
    private final String value;

    private PathFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PathFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PathFormat> knownValues() {
        EnumSet<PathFormat> knownValues = EnumSet.allOf(PathFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PathFormat.class, PathFormat::toString);
    }
}

