/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.EnvironmentDetailsEntity;
import software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsEntity;
import software.amazon.awssdk.services.deadline.model.JobDetailsEntity;
import software.amazon.awssdk.services.deadline.model.StepDetailsEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobEntity> {
    private static final SdkField<EnvironmentDetailsEntity> ENVIRONMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environmentDetails").getter(JobEntity.getter(JobEntity::environmentDetails)).setter(JobEntity.setter(Builder::environmentDetails)).constructor(EnvironmentDetailsEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDetails").build()}).build();
    private static final SdkField<JobAttachmentDetailsEntity> JOB_ATTACHMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobAttachmentDetails").getter(JobEntity.getter(JobEntity::jobAttachmentDetails)).setter(JobEntity.setter(Builder::jobAttachmentDetails)).constructor(JobAttachmentDetailsEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentDetails").build()}).build();
    private static final SdkField<JobDetailsEntity> JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDetails").getter(JobEntity.getter(JobEntity::jobDetails)).setter(JobEntity.setter(Builder::jobDetails)).constructor(JobDetailsEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()}).build();
    private static final SdkField<StepDetailsEntity> STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stepDetails").getter(JobEntity.getter(JobEntity::stepDetails)).setter(JobEntity.setter(Builder::stepDetails)).constructor(StepDetailsEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_DETAILS_FIELD, JOB_ATTACHMENT_DETAILS_FIELD, JOB_DETAILS_FIELD, STEP_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final EnvironmentDetailsEntity environmentDetails;
    private final JobAttachmentDetailsEntity jobAttachmentDetails;
    private final JobDetailsEntity jobDetails;
    private final StepDetailsEntity stepDetails;
    private final Type type;

    private JobEntity(BuilderImpl builder) {
        this.environmentDetails = builder.environmentDetails;
        this.jobAttachmentDetails = builder.jobAttachmentDetails;
        this.jobDetails = builder.jobDetails;
        this.stepDetails = builder.stepDetails;
        this.type = builder.type;
    }

    public final EnvironmentDetailsEntity environmentDetails() {
        return this.environmentDetails;
    }

    public final JobAttachmentDetailsEntity jobAttachmentDetails() {
        return this.jobAttachmentDetails;
    }

    public final JobDetailsEntity jobDetails() {
        return this.jobDetails;
    }

    public final StepDetailsEntity stepDetails() {
        return this.stepDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobAttachmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobEntity)) {
            return false;
        }
        JobEntity other = (JobEntity)obj;
        return Objects.equals(this.environmentDetails(), other.environmentDetails()) && Objects.equals(this.jobAttachmentDetails(), other.jobAttachmentDetails()) && Objects.equals(this.jobDetails(), other.jobDetails()) && Objects.equals(this.stepDetails(), other.stepDetails());
    }

    public final String toString() {
        return ToString.builder((String)"JobEntity").add("EnvironmentDetails", (Object)this.environmentDetails()).add("JobAttachmentDetails", (Object)this.jobAttachmentDetails()).add("JobDetails", (Object)this.jobDetails()).add("StepDetails", (Object)this.stepDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentDetails": {
                return Optional.ofNullable(clazz.cast(this.environmentDetails()));
            }
            case "jobAttachmentDetails": {
                return Optional.ofNullable(clazz.cast(this.jobAttachmentDetails()));
            }
            case "jobDetails": {
                return Optional.ofNullable(clazz.cast(this.jobDetails()));
            }
            case "stepDetails": {
                return Optional.ofNullable(clazz.cast(this.stepDetails()));
            }
        }
        return Optional.empty();
    }

    public static JobEntity fromEnvironmentDetails(EnvironmentDetailsEntity environmentDetails) {
        return (JobEntity)JobEntity.builder().environmentDetails(environmentDetails).build();
    }

    public static JobEntity fromEnvironmentDetails(Consumer<EnvironmentDetailsEntity.Builder> environmentDetails) {
        EnvironmentDetailsEntity.Builder builder = EnvironmentDetailsEntity.builder();
        environmentDetails.accept(builder);
        return JobEntity.fromEnvironmentDetails((EnvironmentDetailsEntity)builder.build());
    }

    public static JobEntity fromJobAttachmentDetails(JobAttachmentDetailsEntity jobAttachmentDetails) {
        return (JobEntity)JobEntity.builder().jobAttachmentDetails(jobAttachmentDetails).build();
    }

    public static JobEntity fromJobAttachmentDetails(Consumer<JobAttachmentDetailsEntity.Builder> jobAttachmentDetails) {
        JobAttachmentDetailsEntity.Builder builder = JobAttachmentDetailsEntity.builder();
        jobAttachmentDetails.accept(builder);
        return JobEntity.fromJobAttachmentDetails((JobAttachmentDetailsEntity)builder.build());
    }

    public static JobEntity fromJobDetails(JobDetailsEntity jobDetails) {
        return (JobEntity)JobEntity.builder().jobDetails(jobDetails).build();
    }

    public static JobEntity fromJobDetails(Consumer<JobDetailsEntity.Builder> jobDetails) {
        JobDetailsEntity.Builder builder = JobDetailsEntity.builder();
        jobDetails.accept(builder);
        return JobEntity.fromJobDetails((JobDetailsEntity)builder.build());
    }

    public static JobEntity fromStepDetails(StepDetailsEntity stepDetails) {
        return (JobEntity)JobEntity.builder().stepDetails(stepDetails).build();
    }

    public static JobEntity fromStepDetails(Consumer<StepDetailsEntity.Builder> stepDetails) {
        StepDetailsEntity.Builder builder = StepDetailsEntity.builder();
        stepDetails.accept(builder);
        return JobEntity.fromStepDetails((StepDetailsEntity)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobEntity, T> g) {
        return obj -> g.apply((JobEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ENVIRONMENT_DETAILS,
        JOB_ATTACHMENT_DETAILS,
        JOB_DETAILS,
        STEP_DETAILS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EnvironmentDetailsEntity environmentDetails;
        private JobAttachmentDetailsEntity jobAttachmentDetails;
        private JobDetailsEntity jobDetails;
        private StepDetailsEntity stepDetails;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobEntity model) {
            this.environmentDetails(model.environmentDetails);
            this.jobAttachmentDetails(model.jobAttachmentDetails);
            this.jobDetails(model.jobDetails);
            this.stepDetails(model.stepDetails);
        }

        public final EnvironmentDetailsEntity.Builder getEnvironmentDetails() {
            return this.environmentDetails != null ? this.environmentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDetails(EnvironmentDetailsEntity.BuilderImpl environmentDetails) {
            EnvironmentDetailsEntity oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails != null ? environmentDetails.build() : null;
            this.handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
        }

        @Override
        public final Builder environmentDetails(EnvironmentDetailsEntity environmentDetails) {
            EnvironmentDetailsEntity oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails;
            this.handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
            return this;
        }

        public final JobAttachmentDetailsEntity.Builder getJobAttachmentDetails() {
            return this.jobAttachmentDetails != null ? this.jobAttachmentDetails.toBuilder() : null;
        }

        public final void setJobAttachmentDetails(JobAttachmentDetailsEntity.BuilderImpl jobAttachmentDetails) {
            JobAttachmentDetailsEntity oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails != null ? jobAttachmentDetails.build() : null;
            this.handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
        }

        @Override
        public final Builder jobAttachmentDetails(JobAttachmentDetailsEntity jobAttachmentDetails) {
            JobAttachmentDetailsEntity oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails;
            this.handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
            return this;
        }

        public final JobDetailsEntity.Builder getJobDetails() {
            return this.jobDetails != null ? this.jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobDetailsEntity.BuilderImpl jobDetails) {
            JobDetailsEntity oldValue = this.jobDetails;
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
            this.handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
        }

        @Override
        public final Builder jobDetails(JobDetailsEntity jobDetails) {
            JobDetailsEntity oldValue = this.jobDetails;
            this.jobDetails = jobDetails;
            this.handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
            return this;
        }

        public final StepDetailsEntity.Builder getStepDetails() {
            return this.stepDetails != null ? this.stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetailsEntity.BuilderImpl stepDetails) {
            StepDetailsEntity oldValue = this.stepDetails;
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
            this.handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
        }

        @Override
        public final Builder stepDetails(StepDetailsEntity stepDetails) {
            StepDetailsEntity oldValue = this.stepDetails;
            this.stepDetails = stepDetails;
            this.handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
            return this;
        }

        public JobEntity build() {
            return new JobEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobEntity> {
        public Builder environmentDetails(EnvironmentDetailsEntity var1);

        default public Builder environmentDetails(Consumer<EnvironmentDetailsEntity.Builder> environmentDetails) {
            return this.environmentDetails((EnvironmentDetailsEntity)((EnvironmentDetailsEntity.Builder)EnvironmentDetailsEntity.builder().applyMutation(environmentDetails)).build());
        }

        public Builder jobAttachmentDetails(JobAttachmentDetailsEntity var1);

        default public Builder jobAttachmentDetails(Consumer<JobAttachmentDetailsEntity.Builder> jobAttachmentDetails) {
            return this.jobAttachmentDetails((JobAttachmentDetailsEntity)((JobAttachmentDetailsEntity.Builder)JobAttachmentDetailsEntity.builder().applyMutation(jobAttachmentDetails)).build());
        }

        public Builder jobDetails(JobDetailsEntity var1);

        default public Builder jobDetails(Consumer<JobDetailsEntity.Builder> jobDetails) {
            return this.jobDetails((JobDetailsEntity)((JobDetailsEntity.Builder)JobDetailsEntity.builder().applyMutation(jobDetails)).build());
        }

        public Builder stepDetails(StepDetailsEntity var1);

        default public Builder stepDetails(Consumer<StepDetailsEntity.Builder> stepDetails) {
            return this.stepDetails((StepDetailsEntity)((StepDetailsEntity.Builder)StepDetailsEntity.builder().applyMutation(stepDetails)).build());
        }
    }
}

