/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.Period;
import software.amazon.awssdk.services.deadline.model.SessionsStatisticsResources;
import software.amazon.awssdk.services.deadline.model.UsageGroupByCopier;
import software.amazon.awssdk.services.deadline.model.UsageGroupByField;
import software.amazon.awssdk.services.deadline.model.UsageStatistic;
import software.amazon.awssdk.services.deadline.model.UsageStatisticsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSessionsStatisticsAggregationRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, StartSessionsStatisticsAggregationRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::endTime)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::farmId)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupBy").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::groupByAsStrings)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::groupByWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::periodAsString)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<SessionsStatisticsResources> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceIds").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::resourceIds)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::resourceIds)).constructor(SessionsStatisticsResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::startTime)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statistics").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::statisticsAsStrings)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::statisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timezone").getter(StartSessionsStatisticsAggregationRequest.getter(StartSessionsStatisticsAggregationRequest::timezone)).setter(StartSessionsStatisticsAggregationRequest.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, FARM_ID_FIELD, GROUP_BY_FIELD, PERIOD_FIELD, RESOURCE_IDS_FIELD, START_TIME_FIELD, STATISTICS_FIELD, TIMEZONE_FIELD));
    private final Instant endTime;
    private final String farmId;
    private final List<String> groupBy;
    private final String period;
    private final SessionsStatisticsResources resourceIds;
    private final Instant startTime;
    private final List<String> statistics;
    private final String timezone;

    private StartSessionsStatisticsAggregationRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.farmId = builder.farmId;
        this.groupBy = builder.groupBy;
        this.period = builder.period;
        this.resourceIds = builder.resourceIds;
        this.startTime = builder.startTime;
        this.statistics = builder.statistics;
        this.timezone = builder.timezone;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final List<UsageGroupByField> groupBy() {
        return UsageGroupByCopier.copyStringToEnum(this.groupBy);
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<String> groupByAsStrings() {
        return this.groupBy;
    }

    public final Period period() {
        return Period.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final SessionsStatisticsResources resourceIds() {
        return this.resourceIds;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final List<UsageStatistic> statistics() {
        return UsageStatisticsCopier.copyStringToEnum(this.statistics);
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<String> statisticsAsStrings() {
        return this.statistics;
    }

    public final String timezone() {
        return this.timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionsStatisticsAggregationRequest)) {
            return false;
        }
        StartSessionsStatisticsAggregationRequest other = (StartSessionsStatisticsAggregationRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.farmId(), other.farmId()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupByAsStrings(), other.groupByAsStrings()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.startTime(), other.startTime()) && this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings()) && Objects.equals(this.timezone(), other.timezone());
    }

    public final String toString() {
        return ToString.builder((String)"StartSessionsStatisticsAggregationRequest").add("EndTime", (Object)this.endTime()).add("FarmId", (Object)this.farmId()).add("GroupBy", this.hasGroupBy() ? this.groupByAsStrings() : null).add("Period", (Object)this.periodAsString()).add("ResourceIds", (Object)this.resourceIds()).add("StartTime", (Object)this.startTime()).add("Statistics", this.hasStatistics() ? this.statisticsAsStrings() : null).add("Timezone", (Object)this.timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsStrings()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "resourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statisticsAsStrings()));
            }
            case "timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSessionsStatisticsAggregationRequest, T> g) {
        return obj -> g.apply((StartSessionsStatisticsAggregationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private Instant endTime;
        private String farmId;
        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();
        private String period;
        private SessionsStatisticsResources resourceIds;
        private Instant startTime;
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionsStatisticsAggregationRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.farmId(model.farmId);
            this.groupByWithStrings(model.groupBy);
            this.period(model.period);
            this.resourceIds(model.resourceIds);
            this.startTime(model.startTime);
            this.statisticsWithStrings(model.statistics);
            this.timezone(model.timezone);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (this.groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = UsageGroupByCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = UsageGroupByCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String ... groupBy) {
            this.groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<UsageGroupByField> groupBy) {
            this.groupBy = UsageGroupByCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(UsageGroupByField ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(Period period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final SessionsStatisticsResources.Builder getResourceIds() {
            return this.resourceIds != null ? this.resourceIds.toBuilder() : null;
        }

        public final void setResourceIds(SessionsStatisticsResources.BuilderImpl resourceIds) {
            this.resourceIds = resourceIds != null ? resourceIds.build() : null;
        }

        @Override
        public final Builder resourceIds(SessionsStatisticsResources resourceIds) {
            this.resourceIds = resourceIds;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Collection<String> getStatistics() {
            if (this.statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = UsageStatisticsCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = UsageStatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String ... statistics) {
            this.statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<UsageStatistic> statistics) {
            this.statistics = UsageStatisticsCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(UsageStatistic ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSessionsStatisticsAggregationRequest build() {
            return new StartSessionsStatisticsAggregationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSessionsStatisticsAggregationRequest> {
        public Builder endTime(Instant var1);

        public Builder farmId(String var1);

        public Builder groupByWithStrings(Collection<String> var1);

        public Builder groupByWithStrings(String ... var1);

        public Builder groupBy(Collection<UsageGroupByField> var1);

        public Builder groupBy(UsageGroupByField ... var1);

        public Builder period(String var1);

        public Builder period(Period var1);

        public Builder resourceIds(SessionsStatisticsResources var1);

        default public Builder resourceIds(Consumer<SessionsStatisticsResources.Builder> resourceIds) {
            return this.resourceIds((SessionsStatisticsResources)((SessionsStatisticsResources.Builder)SessionsStatisticsResources.builder().applyMutation(resourceIds)).build());
        }

        public Builder startTime(Instant var1);

        public Builder statisticsWithStrings(Collection<String> var1);

        public Builder statisticsWithStrings(String ... var1);

        public Builder statistics(Collection<UsageStatistic> var1);

        public Builder statistics(UsageStatistic ... var1);

        public Builder timezone(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

