/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.AssignedSessionAction;
import software.amazon.awssdk.services.deadline.model.AssignedSessionActionsCopier;
import software.amazon.awssdk.services.deadline.model.LogConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignedSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssignedSession> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(AssignedSession.getter(AssignedSession::jobId)).setter(AssignedSession.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(AssignedSession.getter(AssignedSession::logConfiguration)).setter(AssignedSession.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(AssignedSession.getter(AssignedSession::queueId)).setter(AssignedSession.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<List<AssignedSessionAction>> SESSION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessionActions").getter(AssignedSession.getter(AssignedSession::sessionActions)).setter(AssignedSession.setter(Builder::sessionActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssignedSessionAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, LOG_CONFIGURATION_FIELD, QUEUE_ID_FIELD, SESSION_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final LogConfiguration logConfiguration;
    private final String queueId;
    private final List<AssignedSessionAction> sessionActions;

    private AssignedSession(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.logConfiguration = builder.logConfiguration;
        this.queueId = builder.queueId;
        this.sessionActions = builder.sessionActions;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final boolean hasSessionActions() {
        return this.sessionActions != null && !(this.sessionActions instanceof SdkAutoConstructList);
    }

    public final List<AssignedSessionAction> sessionActions() {
        return this.sessionActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionActions() ? this.sessionActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignedSession)) {
            return false;
        }
        AssignedSession other = (AssignedSession)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.queueId(), other.queueId()) && this.hasSessionActions() == other.hasSessionActions() && Objects.equals(this.sessionActions(), other.sessionActions());
    }

    public final String toString() {
        return ToString.builder((String)"AssignedSession").add("JobId", (Object)this.jobId()).add("LogConfiguration", (Object)this.logConfiguration()).add("QueueId", (Object)this.queueId()).add("SessionActions", this.hasSessionActions() ? this.sessionActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "sessionActions": {
                return Optional.ofNullable(clazz.cast(this.sessionActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignedSession, T> g) {
        return obj -> g.apply((AssignedSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private LogConfiguration logConfiguration;
        private String queueId;
        private List<AssignedSessionAction> sessionActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssignedSession model) {
            this.jobId(model.jobId);
            this.logConfiguration(model.logConfiguration);
            this.queueId(model.queueId);
            this.sessionActions(model.sessionActions);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final List<AssignedSessionAction.Builder> getSessionActions() {
            List<AssignedSessionAction.Builder> result = AssignedSessionActionsCopier.copyToBuilder(this.sessionActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionActions(Collection<AssignedSessionAction.BuilderImpl> sessionActions) {
            this.sessionActions = AssignedSessionActionsCopier.copyFromBuilder(sessionActions);
        }

        @Override
        public final Builder sessionActions(Collection<AssignedSessionAction> sessionActions) {
            this.sessionActions = AssignedSessionActionsCopier.copy(sessionActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionActions(AssignedSessionAction ... sessionActions) {
            this.sessionActions(Arrays.asList(sessionActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionActions(Consumer<AssignedSessionAction.Builder> ... sessionActions) {
            this.sessionActions(Stream.of(sessionActions).map(c -> (AssignedSessionAction)((AssignedSessionAction.Builder)AssignedSessionAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssignedSession build() {
            return new AssignedSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssignedSession> {
        public Builder jobId(String var1);

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder queueId(String var1);

        public Builder sessionActions(Collection<AssignedSessionAction> var1);

        public Builder sessionActions(AssignedSessionAction ... var1);

        public Builder sessionActions(Consumer<AssignedSessionAction.Builder> ... var1);
    }
}

