/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.BudgetActionToAdd;
import software.amazon.awssdk.services.deadline.model.BudgetActionsToAddCopier;
import software.amazon.awssdk.services.deadline.model.BudgetSchedule;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.UsageTrackingResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBudgetRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, CreateBudgetRequest> {
    private static final SdkField<List<BudgetActionToAdd>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(CreateBudgetRequest.getter(CreateBudgetRequest::actions)).setter(CreateBudgetRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetActionToAdd::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("approximateDollarLimit").getter(CreateBudgetRequest.getter(CreateBudgetRequest::approximateDollarLimit)).setter(CreateBudgetRequest.setter(Builder::approximateDollarLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateBudgetRequest.getter(CreateBudgetRequest::clientToken)).setter(CreateBudgetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateBudgetRequest.getter(CreateBudgetRequest::description)).setter(CreateBudgetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateBudgetRequest.getter(CreateBudgetRequest::displayName)).setter(CreateBudgetRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(CreateBudgetRequest.getter(CreateBudgetRequest::farmId)).setter(CreateBudgetRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<BudgetSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(CreateBudgetRequest.getter(CreateBudgetRequest::schedule)).setter(CreateBudgetRequest.setter(Builder::schedule)).constructor(BudgetSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<UsageTrackingResource> USAGE_TRACKING_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usageTrackingResource").getter(CreateBudgetRequest.getter(CreateBudgetRequest::usageTrackingResource)).setter(CreateBudgetRequest.setter(Builder::usageTrackingResource)).constructor(UsageTrackingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTrackingResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, APPROXIMATE_DOLLAR_LIMIT_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, FARM_ID_FIELD, SCHEDULE_FIELD, USAGE_TRACKING_RESOURCE_FIELD));
    private final List<BudgetActionToAdd> actions;
    private final Float approximateDollarLimit;
    private final String clientToken;
    private final String description;
    private final String displayName;
    private final String farmId;
    private final BudgetSchedule schedule;
    private final UsageTrackingResource usageTrackingResource;

    private CreateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.farmId = builder.farmId;
        this.schedule = builder.schedule;
        this.usageTrackingResource = builder.usageTrackingResource;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<BudgetActionToAdd> actions() {
        return this.actions;
    }

    public final Float approximateDollarLimit() {
        return this.approximateDollarLimit;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final BudgetSchedule schedule() {
        return this.schedule;
    }

    public final UsageTrackingResource usageTrackingResource() {
        return this.usageTrackingResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTrackingResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest)((Object)obj);
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.approximateDollarLimit(), other.approximateDollarLimit()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.usageTrackingResource(), other.usageTrackingResource());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBudgetRequest").add("Actions", this.hasActions() ? this.actions() : null).add("ApproximateDollarLimit", (Object)this.approximateDollarLimit()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)this.displayName()).add("FarmId", (Object)this.farmId()).add("Schedule", (Object)this.schedule()).add("UsageTrackingResource", (Object)this.usageTrackingResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "approximateDollarLimit": {
                return Optional.ofNullable(clazz.cast(this.approximateDollarLimit()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "usageTrackingResource": {
                return Optional.ofNullable(clazz.cast(this.usageTrackingResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBudgetRequest, T> g) {
        return obj -> g.apply((CreateBudgetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private List<BudgetActionToAdd> actions = DefaultSdkAutoConstructList.getInstance();
        private Float approximateDollarLimit;
        private String clientToken;
        private String description;
        private String displayName;
        private String farmId;
        private BudgetSchedule schedule;
        private UsageTrackingResource usageTrackingResource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBudgetRequest model) {
            super(model);
            this.actions(model.actions);
            this.approximateDollarLimit(model.approximateDollarLimit);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.displayName(model.displayName);
            this.farmId(model.farmId);
            this.schedule(model.schedule);
            this.usageTrackingResource(model.usageTrackingResource);
        }

        public final List<BudgetActionToAdd.Builder> getActions() {
            List<BudgetActionToAdd.Builder> result = BudgetActionsToAddCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<BudgetActionToAdd.BuilderImpl> actions) {
            this.actions = BudgetActionsToAddCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<BudgetActionToAdd> actions) {
            this.actions = BudgetActionsToAddCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(BudgetActionToAdd ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<BudgetActionToAdd.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (BudgetActionToAdd)((BudgetActionToAdd.Builder)BudgetActionToAdd.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getApproximateDollarLimit() {
            return this.approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final BudgetSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(BudgetSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(BudgetSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final UsageTrackingResource.Builder getUsageTrackingResource() {
            return this.usageTrackingResource != null ? this.usageTrackingResource.toBuilder() : null;
        }

        public final void setUsageTrackingResource(UsageTrackingResource.BuilderImpl usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource != null ? usageTrackingResource.build() : null;
        }

        @Override
        public final Builder usageTrackingResource(UsageTrackingResource usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBudgetRequest build() {
            return new CreateBudgetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBudgetRequest> {
        public Builder actions(Collection<BudgetActionToAdd> var1);

        public Builder actions(BudgetActionToAdd ... var1);

        public Builder actions(Consumer<BudgetActionToAdd.Builder> ... var1);

        public Builder approximateDollarLimit(Float var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder farmId(String var1);

        public Builder schedule(BudgetSchedule var1);

        default public Builder schedule(Consumer<BudgetSchedule.Builder> schedule) {
            return this.schedule((BudgetSchedule)((BudgetSchedule.Builder)BudgetSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder usageTrackingResource(UsageTrackingResource var1);

        default public Builder usageTrackingResource(Consumer<UsageTrackingResource.Builder> usageTrackingResource) {
            return this.usageTrackingResource((UsageTrackingResource)((UsageTrackingResource.Builder)UsageTrackingResource.builder().applyMutation(usageTrackingResource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

