/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.services.deadline.waiters.DeadlineWaiter;
import software.amazon.awssdk.services.deadline.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultDeadlineWaiter
implements DeadlineWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final DeadlineClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetFleetResponse> fleetActiveWaiter;
    private final Waiter<GetJobResponse> jobCreateCompleteWaiter;
    private final Waiter<GetLicenseEndpointResponse> licenseEndpointDeletedWaiter;
    private final Waiter<GetLicenseEndpointResponse> licenseEndpointValidWaiter;
    private final Waiter<GetQueueFleetAssociationResponse> queueFleetAssociationStoppedWaiter;
    private final Waiter<GetQueueResponse> queueSchedulingWaiter;
    private final Waiter<GetQueueResponse> queueSchedulingBlockedWaiter;

    private DefaultDeadlineWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DeadlineClient)DeadlineClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.fleetActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetFleetResponse.class).acceptors(DefaultDeadlineWaiter.fleetActiveWaiterAcceptors())).overrideConfiguration(DefaultDeadlineWaiter.fleetActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.jobCreateCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetJobResponse.class).acceptors(DefaultDeadlineWaiter.jobCreateCompleteWaiterAcceptors())).overrideConfiguration(DefaultDeadlineWaiter.jobCreateCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.licenseEndpointDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetLicenseEndpointResponse.class).acceptors(DefaultDeadlineWaiter.licenseEndpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultDeadlineWaiter.licenseEndpointDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.licenseEndpointValidWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetLicenseEndpointResponse.class).acceptors(DefaultDeadlineWaiter.licenseEndpointValidWaiterAcceptors())).overrideConfiguration(DefaultDeadlineWaiter.licenseEndpointValidWaiterConfig(builder.overrideConfiguration))).build();
        this.queueFleetAssociationStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetQueueFleetAssociationResponse.class).acceptors(DefaultDeadlineWaiter.queueFleetAssociationStoppedWaiterAcceptors())).overrideConfiguration(DefaultDeadlineWaiter.queueFleetAssociationStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.queueSchedulingWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetQueueResponse.class).acceptors(DefaultDeadlineWaiter.queueSchedulingWaiterAcceptors())).overrideConfiguration(DefaultDeadlineWaiter.queueSchedulingWaiterConfig(builder.overrideConfiguration))).build();
        this.queueSchedulingBlockedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetQueueResponse.class).acceptors(DefaultDeadlineWaiter.queueSchedulingBlockedWaiterAcceptors())).overrideConfiguration(DefaultDeadlineWaiter.queueSchedulingBlockedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetFleetResponse> waitUntilFleetActive(GetFleetRequest getFleetRequest) {
        return this.fleetActiveWaiter.run(() -> this.client.getFleet(this.applyWaitersUserAgent(getFleetRequest)));
    }

    @Override
    public WaiterResponse<GetFleetResponse> waitUntilFleetActive(GetFleetRequest getFleetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fleetActiveWaiter.run(() -> this.client.getFleet(this.applyWaitersUserAgent(getFleetRequest)), DefaultDeadlineWaiter.fleetActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetJobResponse> waitUntilJobCreateComplete(GetJobRequest getJobRequest) {
        return this.jobCreateCompleteWaiter.run(() -> this.client.getJob(this.applyWaitersUserAgent(getJobRequest)));
    }

    @Override
    public WaiterResponse<GetJobResponse> waitUntilJobCreateComplete(GetJobRequest getJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.jobCreateCompleteWaiter.run(() -> this.client.getJob(this.applyWaitersUserAgent(getJobRequest)), DefaultDeadlineWaiter.jobCreateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        return this.licenseEndpointDeletedWaiter.run(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)));
    }

    @Override
    public WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.licenseEndpointDeletedWaiter.run(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)), DefaultDeadlineWaiter.licenseEndpointDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointValid(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        return this.licenseEndpointValidWaiter.run(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)));
    }

    @Override
    public WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointValid(GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.licenseEndpointValidWaiter.run(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)), DefaultDeadlineWaiter.licenseEndpointValidWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetQueueFleetAssociationResponse> waitUntilQueueFleetAssociationStopped(GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) {
        return this.queueFleetAssociationStoppedWaiter.run(() -> this.client.getQueueFleetAssociation(this.applyWaitersUserAgent(getQueueFleetAssociationRequest)));
    }

    @Override
    public WaiterResponse<GetQueueFleetAssociationResponse> waitUntilQueueFleetAssociationStopped(GetQueueFleetAssociationRequest getQueueFleetAssociationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.queueFleetAssociationStoppedWaiter.run(() -> this.client.getQueueFleetAssociation(this.applyWaitersUserAgent(getQueueFleetAssociationRequest)), DefaultDeadlineWaiter.queueFleetAssociationStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetQueueResponse> waitUntilQueueScheduling(GetQueueRequest getQueueRequest) {
        return this.queueSchedulingWaiter.run(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)));
    }

    @Override
    public WaiterResponse<GetQueueResponse> waitUntilQueueScheduling(GetQueueRequest getQueueRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.queueSchedulingWaiter.run(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)), DefaultDeadlineWaiter.queueSchedulingWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetQueueResponse> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest) {
        return this.queueSchedulingBlockedWaiter.run(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)));
    }

    @Override
    public WaiterResponse<GetQueueResponse> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.queueSchedulingBlockedWaiter.run(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)), DefaultDeadlineWaiter.queueSchedulingBlockedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetFleetResponse>> fleetActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFleetResponse>> result = new ArrayList<WaiterAcceptor<? super GetFleetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetJobResponse>> jobCreateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "CREATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPDATE_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPDATE_FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPDATE_SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPLOAD_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "CREATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLicenseEndpointResponse>> licenseEndpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDeadlineWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "NOT_READY");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLicenseEndpointResponse>> licenseEndpointValidWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "NOT_READY");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetQueueFleetAssociationResponse>> queueFleetAssociationStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetQueueFleetAssociationResponse>> result = new ArrayList<WaiterAcceptor<? super GetQueueFleetAssociationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetQueueResponse>> queueSchedulingWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetQueueResponse>> result = new ArrayList<WaiterAcceptor<? super GetQueueResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SCHEDULING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetQueueResponse>> queueSchedulingBlockedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetQueueResponse>> result = new ArrayList<WaiterAcceptor<? super GetQueueResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SCHEDULING_BLOCKED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration fleetActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration jobCreateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration licenseEndpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(234);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration licenseEndpointValidWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(114);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration queueFleetAssociationStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration queueSchedulingWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(70);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration queueSchedulingBlockedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DeadlineWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DeadlineRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DeadlineRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DeadlineWaiter.Builder {
        private DeadlineClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public DeadlineWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DeadlineWaiter.Builder client(DeadlineClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DeadlineWaiter build() {
            return new DefaultDeadlineWaiter(this);
        }
    }
}

