/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An individual VPC security group and its status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupMembership.Builder, SecurityGroupMembership> {
    private static final SdkField<String> SECURITY_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SecurityGroupMembership::securityGroupIdentifier)).setter(setter(Builder::securityGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SecurityGroupMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SECURITY_GROUP_IDENTIFIER_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String securityGroupIdentifier;

    private final String status;

    private SecurityGroupMembership(BuilderImpl builder) {
        this.securityGroupIdentifier = builder.securityGroupIdentifier;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique ID for this security group.
     * </p>
     * 
     * @return The unique ID for this security group.
     */
    public String securityGroupIdentifier() {
        return securityGroupIdentifier;
    }

    /**
     * <p>
     * The status of this security group.
     * </p>
     * 
     * @return The status of this security group.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupMembership)) {
            return false;
        }
        SecurityGroupMembership other = (SecurityGroupMembership) obj;
        return Objects.equals(securityGroupIdentifier(), other.securityGroupIdentifier())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SecurityGroupMembership").add("SecurityGroupIdentifier", securityGroupIdentifier())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupIdentifier":
            return Optional.ofNullable(clazz.cast(securityGroupIdentifier()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupMembership, T> g) {
        return obj -> g.apply((SecurityGroupMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupMembership> {
        /**
         * <p>
         * The unique ID for this security group.
         * </p>
         * 
         * @param securityGroupIdentifier
         *        The unique ID for this security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdentifier(String securityGroupIdentifier);

        /**
         * <p>
         * The status of this security group.
         * </p>
         * 
         * @param status
         *        The status of this security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String securityGroupIdentifier;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupMembership model) {
            securityGroupIdentifier(model.securityGroupIdentifier);
            status(model.status);
        }

        public final String getSecurityGroupIdentifier() {
            return securityGroupIdentifier;
        }

        @Override
        public final Builder securityGroupIdentifier(String securityGroupIdentifier) {
            this.securityGroupIdentifier = securityGroupIdentifier;
            return this;
        }

        public final void setSecurityGroupIdentifier(String securityGroupIdentifier) {
            this.securityGroupIdentifier = securityGroupIdentifier;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public SecurityGroupMembership build() {
            return new SecurityGroupMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
