/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.ParameterNameValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParameterNameValueMarshaller {
    private static final MarshallingInfo<String> PARAMETERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterName").isBinary(false).build();
    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterValue").isBinary(false).build();
    private static final ParameterNameValueMarshaller INSTANCE = new ParameterNameValueMarshaller();

    private ParameterNameValueMarshaller() {
    }

    public static ParameterNameValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ParameterNameValue parameterNameValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parameterNameValue, (String)"parameterNameValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parameterNameValue.parameterName(), PARAMETERNAME_BINDING);
            protocolMarshaller.marshall((Object)parameterNameValue.parameterValue(), PARAMETERVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

