/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dax.model.DAXRequest;
import software.amazon.awssdk.services.dax.model.ParameterNameValue;
import software.amazon.awssdk.services.dax.model.ParameterNameValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateParameterGroupRequest
extends DAXRequest
implements ToCopyableBuilder<Builder, UpdateParameterGroupRequest> {
    private final String parameterGroupName;
    private final List<ParameterNameValue> parameterNameValues;

    private UpdateParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterNameValues = builder.parameterNameValues;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public List<ParameterNameValue> parameterNameValues() {
        return this.parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterNameValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParameterGroupRequest)) {
            return false;
        }
        UpdateParameterGroupRequest other = (UpdateParameterGroupRequest)((Object)obj);
        return Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.parameterNameValues(), other.parameterNameValues());
    }

    public String toString() {
        return ToString.builder((String)"UpdateParameterGroupRequest").add("ParameterGroupName", (Object)this.parameterGroupName()).add("ParameterNameValues", this.parameterNameValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.of(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterNameValues": {
                return Optional.of(clazz.cast(this.parameterNameValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DAXRequest.BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private List<ParameterNameValue> parameterNameValues;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParameterGroupRequest model) {
            this.parameterGroupName(model.parameterGroupName);
            this.parameterNameValues(model.parameterNameValues);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final Collection<ParameterNameValue.Builder> getParameterNameValues() {
            return this.parameterNameValues != null ? (Collection)this.parameterNameValues.stream().map(ParameterNameValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue ... parameterNameValues) {
            this.parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateParameterGroupRequest build() {
            return new UpdateParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends DAXRequest.Builder,
    CopyableBuilder<Builder, UpdateParameterGroupRequest> {
        public Builder parameterGroupName(String var1);

        public Builder parameterNameValues(Collection<ParameterNameValue> var1);

        public Builder parameterNameValues(ParameterNameValue ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

