/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.ChangeType;
import software.amazon.awssdk.services.dax.model.IsModifiable;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValueListCopier;
import software.amazon.awssdk.services.dax.model.ParameterType;
import software.amazon.awssdk.services.dax.transform.ParameterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Parameter
implements StructuredPojo,
ToCopyableBuilder<Builder, Parameter> {
    private final String parameterName;
    private final String parameterType;
    private final String parameterValue;
    private final List<NodeTypeSpecificValue> nodeTypeSpecificValues;
    private final String description;
    private final String source;
    private final String dataType;
    private final String allowedValues;
    private final String isModifiable;
    private final String changeType;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
        this.nodeTypeSpecificValues = builder.nodeTypeSpecificValues;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.changeType = builder.changeType;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public ParameterType parameterType() {
        return ParameterType.fromValue(this.parameterType);
    }

    public String parameterTypeString() {
        return this.parameterType;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public List<NodeTypeSpecificValue> nodeTypeSpecificValues() {
        return this.nodeTypeSpecificValues;
    }

    public String description() {
        return this.description;
    }

    public String source() {
        return this.source;
    }

    public String dataType() {
        return this.dataType;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public IsModifiable isModifiable() {
        return IsModifiable.fromValue(this.isModifiable);
    }

    public String isModifiableString() {
        return this.isModifiable;
    }

    public ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public String changeTypeString() {
        return this.changeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeTypeSpecificValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.isModifiableString());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.parameterTypeString(), other.parameterTypeString()) && Objects.equals(this.parameterValue(), other.parameterValue()) && Objects.equals(this.nodeTypeSpecificValues(), other.nodeTypeSpecificValues()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.isModifiableString(), other.isModifiableString()) && Objects.equals(this.changeTypeString(), other.changeTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterName() != null) {
            sb.append("ParameterName: ").append(this.parameterName()).append(",");
        }
        if (this.parameterTypeString() != null) {
            sb.append("ParameterType: ").append(this.parameterTypeString()).append(",");
        }
        if (this.parameterValue() != null) {
            sb.append("ParameterValue: ").append(this.parameterValue()).append(",");
        }
        if (this.nodeTypeSpecificValues() != null) {
            sb.append("NodeTypeSpecificValues: ").append(this.nodeTypeSpecificValues()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.dataType() != null) {
            sb.append("DataType: ").append(this.dataType()).append(",");
        }
        if (this.allowedValues() != null) {
            sb.append("AllowedValues: ").append(this.allowedValues()).append(",");
        }
        if (this.isModifiableString() != null) {
            sb.append("IsModifiable: ").append(this.isModifiableString()).append(",");
        }
        if (this.changeTypeString() != null) {
            sb.append("ChangeType: ").append(this.changeTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.of(clazz.cast(this.parameterName()));
            }
            case "ParameterType": {
                return Optional.of(clazz.cast(this.parameterTypeString()));
            }
            case "ParameterValue": {
                return Optional.of(clazz.cast(this.parameterValue()));
            }
            case "NodeTypeSpecificValues": {
                return Optional.of(clazz.cast(this.nodeTypeSpecificValues()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "DataType": {
                return Optional.of(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.of(clazz.cast(this.allowedValues()));
            }
            case "IsModifiable": {
                return Optional.of(clazz.cast(this.isModifiableString()));
            }
            case "ChangeType": {
                return Optional.of(clazz.cast(this.changeTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterType;
        private String parameterValue;
        private List<NodeTypeSpecificValue> nodeTypeSpecificValues;
        private String description;
        private String source;
        private String dataType;
        private String allowedValues;
        private String isModifiable;
        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.parameterName(model.parameterName);
            this.parameterType(model.parameterType);
            this.parameterValue(model.parameterValue);
            this.nodeTypeSpecificValues(model.nodeTypeSpecificValues);
            this.description(model.description);
            this.source(model.source);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.isModifiable(model.isModifiable);
            this.changeType(model.changeType);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterType() {
            return this.parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        @Override
        public final Builder parameterType(ParameterType parameterType) {
            this.parameterType(parameterType.toString());
            return this;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final Collection<NodeTypeSpecificValue.Builder> getNodeTypeSpecificValues() {
            return this.nodeTypeSpecificValues != null ? (Collection)this.nodeTypeSpecificValues.stream().map(NodeTypeSpecificValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copy(nodeTypeSpecificValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeTypeSpecificValues(NodeTypeSpecificValue ... nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues(Arrays.asList(nodeTypeSpecificValues));
            return this;
        }

        public final void setNodeTypeSpecificValues(Collection<NodeTypeSpecificValue.BuilderImpl> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copyFromBuilder(nodeTypeSpecificValues);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final String getIsModifiable() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        @Override
        public final Builder isModifiable(IsModifiable isModifiable) {
            this.isModifiable(isModifiable.toString());
            return this;
        }

        public final void setIsModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType.toString());
            return this;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Parameter> {
        public Builder parameterName(String var1);

        public Builder parameterType(String var1);

        public Builder parameterType(ParameterType var1);

        public Builder parameterValue(String var1);

        public Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> var1);

        public Builder nodeTypeSpecificValues(NodeTypeSpecificValue ... var1);

        public Builder description(String var1);

        public Builder source(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder isModifiable(String var1);

        public Builder isModifiable(IsModifiable var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);
    }
}

