/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue;

@SdkInternalApi
public class NodeTypeSpecificValueMarshaller {
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final NodeTypeSpecificValueMarshaller INSTANCE = new NodeTypeSpecificValueMarshaller();

    public static NodeTypeSpecificValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NodeTypeSpecificValue nodeTypeSpecificValue, ProtocolMarshaller protocolMarshaller) {
        if (nodeTypeSpecificValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)nodeTypeSpecificValue.nodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)nodeTypeSpecificValue.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

