/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.services.dax.transform.ParameterGroupStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterGroupStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterGroupStatus> {
    private final String parameterGroupName;
    private final String parameterApplyStatus;
    private final List<String> nodeIdsToReboot;

    private ParameterGroupStatus(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.nodeIdsToReboot = builder.nodeIdsToReboot;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public String parameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public List<String> nodeIdsToReboot() {
        return this.nodeIdsToReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterGroupName() == null ? 0 : this.parameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.parameterApplyStatus() == null ? 0 : this.parameterApplyStatus().hashCode());
        hashCode = 31 * hashCode + (this.nodeIdsToReboot() == null ? 0 : this.nodeIdsToReboot().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterGroupStatus)) {
            return false;
        }
        ParameterGroupStatus other = (ParameterGroupStatus)obj;
        if (other.parameterGroupName() == null ^ this.parameterGroupName() == null) {
            return false;
        }
        if (other.parameterGroupName() != null && !other.parameterGroupName().equals(this.parameterGroupName())) {
            return false;
        }
        if (other.parameterApplyStatus() == null ^ this.parameterApplyStatus() == null) {
            return false;
        }
        if (other.parameterApplyStatus() != null && !other.parameterApplyStatus().equals(this.parameterApplyStatus())) {
            return false;
        }
        if (other.nodeIdsToReboot() == null ^ this.nodeIdsToReboot() == null) {
            return false;
        }
        return other.nodeIdsToReboot() == null || other.nodeIdsToReboot().equals(this.nodeIdsToReboot());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.parameterGroupName()).append(",");
        }
        if (this.parameterApplyStatus() != null) {
            sb.append("ParameterApplyStatus: ").append(this.parameterApplyStatus()).append(",");
        }
        if (this.nodeIdsToReboot() != null) {
            sb.append("NodeIdsToReboot: ").append(this.nodeIdsToReboot()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterGroupStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private String parameterApplyStatus;
        private List<String> nodeIdsToReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterGroupStatus model) {
            this.setParameterGroupName(model.parameterGroupName);
            this.setParameterApplyStatus(model.parameterApplyStatus);
            this.setNodeIdsToReboot(model.nodeIdsToReboot);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return this.parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<String> getNodeIdsToReboot() {
            return this.nodeIdsToReboot;
        }

        @Override
        public final Builder nodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToReboot(String ... nodeIdsToReboot) {
            this.nodeIdsToReboot(Arrays.asList(nodeIdsToReboot));
            return this;
        }

        public final void setNodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
        }

        public ParameterGroupStatus build() {
            return new ParameterGroupStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterGroupStatus> {
        public Builder parameterGroupName(String var1);

        public Builder parameterApplyStatus(String var1);

        public Builder nodeIdsToReboot(Collection<String> var1);

        public Builder nodeIdsToReboot(String ... var1);
    }
}

