/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dax.model.SubnetGroupNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSubnetGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSubnetGroupsRequest> {
    private final List<String> subnetGroupNames;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeSubnetGroupsRequest(BuilderImpl builder) {
        this.subnetGroupNames = builder.subnetGroupNames;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> subnetGroupNames() {
        return this.subnetGroupNames;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnetGroupNames() == null ? 0 : this.subnetGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsRequest)) {
            return false;
        }
        DescribeSubnetGroupsRequest other = (DescribeSubnetGroupsRequest)((Object)obj);
        if (other.subnetGroupNames() == null ^ this.subnetGroupNames() == null) {
            return false;
        }
        if (other.subnetGroupNames() != null && !other.subnetGroupNames().equals(this.subnetGroupNames())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnetGroupNames() != null) {
            sb.append("SubnetGroupNames: ").append(this.subnetGroupNames()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> subnetGroupNames;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsRequest model) {
            this.setSubnetGroupNames(model.subnetGroupNames);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getSubnetGroupNames() {
            return this.subnetGroupNames;
        }

        @Override
        public final Builder subnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroupNames(String ... subnetGroupNames) {
            this.subnetGroupNames(Arrays.asList(subnetGroupNames));
            return this;
        }

        public final void setSubnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeSubnetGroupsRequest build() {
            return new DescribeSubnetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSubnetGroupsRequest> {
        public Builder subnetGroupNames(Collection<String> var1);

        public Builder subnetGroupNames(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

