/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.ChangeType;
import software.amazon.awssdk.services.dax.model.IsModifiable;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValueListCopier;
import software.amazon.awssdk.services.dax.model.ParameterType;
import software.amazon.awssdk.services.dax.transform.ParameterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Parameter
implements StructuredPojo,
ToCopyableBuilder<Builder, Parameter> {
    private final String parameterName;
    private final String parameterType;
    private final String parameterValue;
    private final List<NodeTypeSpecificValue> nodeTypeSpecificValues;
    private final String description;
    private final String source;
    private final String dataType;
    private final String allowedValues;
    private final String isModifiable;
    private final String changeType;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
        this.nodeTypeSpecificValues = builder.nodeTypeSpecificValues;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.changeType = builder.changeType;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public String parameterType() {
        return this.parameterType;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public List<NodeTypeSpecificValue> nodeTypeSpecificValues() {
        return this.nodeTypeSpecificValues;
    }

    public String description() {
        return this.description;
    }

    public String source() {
        return this.source;
    }

    public String dataType() {
        return this.dataType;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public String isModifiable() {
        return this.isModifiable;
    }

    public String changeType() {
        return this.changeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterName() == null ? 0 : this.parameterName().hashCode());
        hashCode = 31 * hashCode + (this.parameterType() == null ? 0 : this.parameterType().hashCode());
        hashCode = 31 * hashCode + (this.parameterValue() == null ? 0 : this.parameterValue().hashCode());
        hashCode = 31 * hashCode + (this.nodeTypeSpecificValues() == null ? 0 : this.nodeTypeSpecificValues().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.dataType() == null ? 0 : this.dataType().hashCode());
        hashCode = 31 * hashCode + (this.allowedValues() == null ? 0 : this.allowedValues().hashCode());
        hashCode = 31 * hashCode + (this.isModifiable() == null ? 0 : this.isModifiable().hashCode());
        hashCode = 31 * hashCode + (this.changeType() == null ? 0 : this.changeType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (other.parameterName() == null ^ this.parameterName() == null) {
            return false;
        }
        if (other.parameterName() != null && !other.parameterName().equals(this.parameterName())) {
            return false;
        }
        if (other.parameterType() == null ^ this.parameterType() == null) {
            return false;
        }
        if (other.parameterType() != null && !other.parameterType().equals(this.parameterType())) {
            return false;
        }
        if (other.parameterValue() == null ^ this.parameterValue() == null) {
            return false;
        }
        if (other.parameterValue() != null && !other.parameterValue().equals(this.parameterValue())) {
            return false;
        }
        if (other.nodeTypeSpecificValues() == null ^ this.nodeTypeSpecificValues() == null) {
            return false;
        }
        if (other.nodeTypeSpecificValues() != null && !other.nodeTypeSpecificValues().equals(this.nodeTypeSpecificValues())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.dataType() == null ^ this.dataType() == null) {
            return false;
        }
        if (other.dataType() != null && !other.dataType().equals(this.dataType())) {
            return false;
        }
        if (other.allowedValues() == null ^ this.allowedValues() == null) {
            return false;
        }
        if (other.allowedValues() != null && !other.allowedValues().equals(this.allowedValues())) {
            return false;
        }
        if (other.isModifiable() == null ^ this.isModifiable() == null) {
            return false;
        }
        if (other.isModifiable() != null && !other.isModifiable().equals(this.isModifiable())) {
            return false;
        }
        if (other.changeType() == null ^ this.changeType() == null) {
            return false;
        }
        return other.changeType() == null || other.changeType().equals(this.changeType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameterName() != null) {
            sb.append("ParameterName: ").append(this.parameterName()).append(",");
        }
        if (this.parameterType() != null) {
            sb.append("ParameterType: ").append(this.parameterType()).append(",");
        }
        if (this.parameterValue() != null) {
            sb.append("ParameterValue: ").append(this.parameterValue()).append(",");
        }
        if (this.nodeTypeSpecificValues() != null) {
            sb.append("NodeTypeSpecificValues: ").append(this.nodeTypeSpecificValues()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.dataType() != null) {
            sb.append("DataType: ").append(this.dataType()).append(",");
        }
        if (this.allowedValues() != null) {
            sb.append("AllowedValues: ").append(this.allowedValues()).append(",");
        }
        if (this.isModifiable() != null) {
            sb.append("IsModifiable: ").append(this.isModifiable()).append(",");
        }
        if (this.changeType() != null) {
            sb.append("ChangeType: ").append(this.changeType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterType;
        private String parameterValue;
        private List<NodeTypeSpecificValue> nodeTypeSpecificValues;
        private String description;
        private String source;
        private String dataType;
        private String allowedValues;
        private String isModifiable;
        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.setParameterName(model.parameterName);
            this.setParameterType(model.parameterType);
            this.setParameterValue(model.parameterValue);
            this.setNodeTypeSpecificValues(model.nodeTypeSpecificValues);
            this.setDescription(model.description);
            this.setSource(model.source);
            this.setDataType(model.dataType);
            this.setAllowedValues(model.allowedValues);
            this.setIsModifiable(model.isModifiable);
            this.setChangeType(model.changeType);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterType() {
            return this.parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        @Override
        public final Builder parameterType(ParameterType parameterType) {
            this.parameterType(parameterType.toString());
            return this;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        public final void setParameterType(ParameterType parameterType) {
            this.parameterType(parameterType.toString());
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final Collection<NodeTypeSpecificValue> getNodeTypeSpecificValues() {
            return this.nodeTypeSpecificValues;
        }

        @Override
        public final Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copy(nodeTypeSpecificValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeTypeSpecificValues(NodeTypeSpecificValue ... nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues(Arrays.asList(nodeTypeSpecificValues));
            return this;
        }

        public final void setNodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copy(nodeTypeSpecificValues);
        }

        @SafeVarargs
        public final void setNodeTypeSpecificValues(NodeTypeSpecificValue ... nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues(Arrays.asList(nodeTypeSpecificValues));
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final String getIsModifiable() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        @Override
        public final Builder isModifiable(IsModifiable isModifiable) {
            this.isModifiable(isModifiable.toString());
            return this;
        }

        public final void setIsModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final void setIsModifiable(IsModifiable isModifiable) {
            this.isModifiable(isModifiable.toString());
        }

        public final String getChangeType() {
            return this.changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType.toString());
            return this;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public final void setChangeType(ChangeType changeType) {
            this.changeType(changeType.toString());
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Parameter> {
        public Builder parameterName(String var1);

        public Builder parameterType(String var1);

        public Builder parameterType(ParameterType var1);

        public Builder parameterValue(String var1);

        public Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> var1);

        public Builder nodeTypeSpecificValues(NodeTypeSpecificValue ... var1);

        public Builder description(String var1);

        public Builder source(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder isModifiable(String var1);

        public Builder isModifiable(IsModifiable var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);
    }
}

