/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dax.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DecreaseReplicationFactorRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DecreaseReplicationFactorRequest> {
    private final String clusterName;
    private final Integer newReplicationFactor;
    private final List<String> availabilityZones;
    private final List<String> nodeIdsToRemove;

    private DecreaseReplicationFactorRequest(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.newReplicationFactor = builder.newReplicationFactor;
        this.availabilityZones = builder.availabilityZones;
        this.nodeIdsToRemove = builder.nodeIdsToRemove;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Integer newReplicationFactor() {
        return this.newReplicationFactor;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> nodeIdsToRemove() {
        return this.nodeIdsToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterName() == null ? 0 : this.clusterName().hashCode());
        hashCode = 31 * hashCode + (this.newReplicationFactor() == null ? 0 : this.newReplicationFactor().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.nodeIdsToRemove() == null ? 0 : this.nodeIdsToRemove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseReplicationFactorRequest)) {
            return false;
        }
        DecreaseReplicationFactorRequest other = (DecreaseReplicationFactorRequest)((Object)obj);
        if (other.clusterName() == null ^ this.clusterName() == null) {
            return false;
        }
        if (other.clusterName() != null && !other.clusterName().equals(this.clusterName())) {
            return false;
        }
        if (other.newReplicationFactor() == null ^ this.newReplicationFactor() == null) {
            return false;
        }
        if (other.newReplicationFactor() != null && !other.newReplicationFactor().equals(this.newReplicationFactor())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.nodeIdsToRemove() == null ^ this.nodeIdsToRemove() == null) {
            return false;
        }
        return other.nodeIdsToRemove() == null || other.nodeIdsToRemove().equals(this.nodeIdsToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName() != null) {
            sb.append("ClusterName: ").append(this.clusterName()).append(",");
        }
        if (this.newReplicationFactor() != null) {
            sb.append("NewReplicationFactor: ").append(this.newReplicationFactor()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.nodeIdsToRemove() != null) {
            sb.append("NodeIdsToRemove: ").append(this.nodeIdsToRemove()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private Integer newReplicationFactor;
        private List<String> availabilityZones;
        private List<String> nodeIdsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseReplicationFactorRequest model) {
            this.setClusterName(model.clusterName);
            this.setNewReplicationFactor(model.newReplicationFactor);
            this.setAvailabilityZones(model.availabilityZones);
            this.setNodeIdsToRemove(model.nodeIdsToRemove);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Integer getNewReplicationFactor() {
            return this.newReplicationFactor;
        }

        @Override
        public final Builder newReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
            return this;
        }

        public final void setNewReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
        }

        public final Collection<String> getNodeIdsToRemove() {
            return this.nodeIdsToRemove;
        }

        @Override
        public final Builder nodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToRemove(String ... nodeIdsToRemove) {
            this.nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
            return this;
        }

        public final void setNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
        }

        @SafeVarargs
        public final void setNodeIdsToRemove(String ... nodeIdsToRemove) {
            this.nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
        }

        public DecreaseReplicationFactorRequest build() {
            return new DecreaseReplicationFactorRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DecreaseReplicationFactorRequest> {
        public Builder clusterName(String var1);

        public Builder newReplicationFactor(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder nodeIdsToRemove(Collection<String> var1);

        public Builder nodeIdsToRemove(String ... var1);
    }
}

