/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Endpoint;
import software.amazon.awssdk.services.dax.model.Node;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.services.dax.model.NodeListCopier;
import software.amazon.awssdk.services.dax.model.NotificationConfiguration;
import software.amazon.awssdk.services.dax.model.ParameterGroupStatus;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembership;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.dax.transform.ClusterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Cluster
implements StructuredPojo,
ToCopyableBuilder<Builder, Cluster> {
    private final String clusterName;
    private final String description;
    private final String clusterArn;
    private final Integer totalNodes;
    private final Integer activeNodes;
    private final String nodeType;
    private final String status;
    private final Endpoint clusterDiscoveryEndpoint;
    private final List<String> nodeIdsToRemove;
    private final List<Node> nodes;
    private final String preferredMaintenanceWindow;
    private final NotificationConfiguration notificationConfiguration;
    private final String subnetGroup;
    private final List<SecurityGroupMembership> securityGroups;
    private final String iamRoleArn;
    private final ParameterGroupStatus parameterGroup;

    private Cluster(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.description = builder.description;
        this.clusterArn = builder.clusterArn;
        this.totalNodes = builder.totalNodes;
        this.activeNodes = builder.activeNodes;
        this.nodeType = builder.nodeType;
        this.status = builder.status;
        this.clusterDiscoveryEndpoint = builder.clusterDiscoveryEndpoint;
        this.nodeIdsToRemove = builder.nodeIdsToRemove;
        this.nodes = builder.nodes;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.subnetGroup = builder.subnetGroup;
        this.securityGroups = builder.securityGroups;
        this.iamRoleArn = builder.iamRoleArn;
        this.parameterGroup = builder.parameterGroup;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String description() {
        return this.description;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public Integer totalNodes() {
        return this.totalNodes;
    }

    public Integer activeNodes() {
        return this.activeNodes;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public String status() {
        return this.status;
    }

    public Endpoint clusterDiscoveryEndpoint() {
        return this.clusterDiscoveryEndpoint;
    }

    public List<String> nodeIdsToRemove() {
        return this.nodeIdsToRemove;
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public String subnetGroup() {
        return this.subnetGroup;
    }

    public List<SecurityGroupMembership> securityGroups() {
        return this.securityGroups;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public ParameterGroupStatus parameterGroup() {
        return this.parameterGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterName() == null ? 0 : this.clusterName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.clusterArn() == null ? 0 : this.clusterArn().hashCode());
        hashCode = 31 * hashCode + (this.totalNodes() == null ? 0 : this.totalNodes().hashCode());
        hashCode = 31 * hashCode + (this.activeNodes() == null ? 0 : this.activeNodes().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.clusterDiscoveryEndpoint() == null ? 0 : this.clusterDiscoveryEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.nodeIdsToRemove() == null ? 0 : this.nodeIdsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.nodes() == null ? 0 : this.nodes().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.notificationConfiguration() == null ? 0 : this.notificationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.subnetGroup() == null ? 0 : this.subnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.iamRoleArn() == null ? 0 : this.iamRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.parameterGroup() == null ? 0 : this.parameterGroup().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.clusterName() == null ^ this.clusterName() == null) {
            return false;
        }
        if (other.clusterName() != null && !other.clusterName().equals(this.clusterName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.clusterArn() == null ^ this.clusterArn() == null) {
            return false;
        }
        if (other.clusterArn() != null && !other.clusterArn().equals(this.clusterArn())) {
            return false;
        }
        if (other.totalNodes() == null ^ this.totalNodes() == null) {
            return false;
        }
        if (other.totalNodes() != null && !other.totalNodes().equals(this.totalNodes())) {
            return false;
        }
        if (other.activeNodes() == null ^ this.activeNodes() == null) {
            return false;
        }
        if (other.activeNodes() != null && !other.activeNodes().equals(this.activeNodes())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.clusterDiscoveryEndpoint() == null ^ this.clusterDiscoveryEndpoint() == null) {
            return false;
        }
        if (other.clusterDiscoveryEndpoint() != null && !other.clusterDiscoveryEndpoint().equals(this.clusterDiscoveryEndpoint())) {
            return false;
        }
        if (other.nodeIdsToRemove() == null ^ this.nodeIdsToRemove() == null) {
            return false;
        }
        if (other.nodeIdsToRemove() != null && !other.nodeIdsToRemove().equals(this.nodeIdsToRemove())) {
            return false;
        }
        if (other.nodes() == null ^ this.nodes() == null) {
            return false;
        }
        if (other.nodes() != null && !other.nodes().equals(this.nodes())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.notificationConfiguration() == null ^ this.notificationConfiguration() == null) {
            return false;
        }
        if (other.notificationConfiguration() != null && !other.notificationConfiguration().equals(this.notificationConfiguration())) {
            return false;
        }
        if (other.subnetGroup() == null ^ this.subnetGroup() == null) {
            return false;
        }
        if (other.subnetGroup() != null && !other.subnetGroup().equals(this.subnetGroup())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.iamRoleArn() == null ^ this.iamRoleArn() == null) {
            return false;
        }
        if (other.iamRoleArn() != null && !other.iamRoleArn().equals(this.iamRoleArn())) {
            return false;
        }
        if (other.parameterGroup() == null ^ this.parameterGroup() == null) {
            return false;
        }
        return other.parameterGroup() == null || other.parameterGroup().equals(this.parameterGroup());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName() != null) {
            sb.append("ClusterName: ").append(this.clusterName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.clusterArn() != null) {
            sb.append("ClusterArn: ").append(this.clusterArn()).append(",");
        }
        if (this.totalNodes() != null) {
            sb.append("TotalNodes: ").append(this.totalNodes()).append(",");
        }
        if (this.activeNodes() != null) {
            sb.append("ActiveNodes: ").append(this.activeNodes()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.clusterDiscoveryEndpoint() != null) {
            sb.append("ClusterDiscoveryEndpoint: ").append(this.clusterDiscoveryEndpoint()).append(",");
        }
        if (this.nodeIdsToRemove() != null) {
            sb.append("NodeIdsToRemove: ").append(this.nodeIdsToRemove()).append(",");
        }
        if (this.nodes() != null) {
            sb.append("Nodes: ").append(this.nodes()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.notificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.notificationConfiguration()).append(",");
        }
        if (this.subnetGroup() != null) {
            sb.append("SubnetGroup: ").append(this.subnetGroup()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.iamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.iamRoleArn()).append(",");
        }
        if (this.parameterGroup() != null) {
            sb.append("ParameterGroup: ").append(this.parameterGroup()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String description;
        private String clusterArn;
        private Integer totalNodes;
        private Integer activeNodes;
        private String nodeType;
        private String status;
        private Endpoint clusterDiscoveryEndpoint;
        private List<String> nodeIdsToRemove;
        private List<Node> nodes;
        private String preferredMaintenanceWindow;
        private NotificationConfiguration notificationConfiguration;
        private String subnetGroup;
        private List<SecurityGroupMembership> securityGroups;
        private String iamRoleArn;
        private ParameterGroupStatus parameterGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.setClusterName(model.clusterName);
            this.setDescription(model.description);
            this.setClusterArn(model.clusterArn);
            this.setTotalNodes(model.totalNodes);
            this.setActiveNodes(model.activeNodes);
            this.setNodeType(model.nodeType);
            this.setStatus(model.status);
            this.setClusterDiscoveryEndpoint(model.clusterDiscoveryEndpoint);
            this.setNodeIdsToRemove(model.nodeIdsToRemove);
            this.setNodes(model.nodes);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setNotificationConfiguration(model.notificationConfiguration);
            this.setSubnetGroup(model.subnetGroup);
            this.setSecurityGroups(model.securityGroups);
            this.setIamRoleArn(model.iamRoleArn);
            this.setParameterGroup(model.parameterGroup);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final Integer getTotalNodes() {
            return this.totalNodes;
        }

        @Override
        public final Builder totalNodes(Integer totalNodes) {
            this.totalNodes = totalNodes;
            return this;
        }

        public final void setTotalNodes(Integer totalNodes) {
            this.totalNodes = totalNodes;
        }

        public final Integer getActiveNodes() {
            return this.activeNodes;
        }

        @Override
        public final Builder activeNodes(Integer activeNodes) {
            this.activeNodes = activeNodes;
            return this;
        }

        public final void setActiveNodes(Integer activeNodes) {
            this.activeNodes = activeNodes;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Endpoint getClusterDiscoveryEndpoint() {
            return this.clusterDiscoveryEndpoint;
        }

        @Override
        public final Builder clusterDiscoveryEndpoint(Endpoint clusterDiscoveryEndpoint) {
            this.clusterDiscoveryEndpoint = clusterDiscoveryEndpoint;
            return this;
        }

        public final void setClusterDiscoveryEndpoint(Endpoint clusterDiscoveryEndpoint) {
            this.clusterDiscoveryEndpoint = clusterDiscoveryEndpoint;
        }

        public final Collection<String> getNodeIdsToRemove() {
            return this.nodeIdsToRemove;
        }

        @Override
        public final Builder nodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToRemove(String ... nodeIdsToRemove) {
            this.nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
            return this;
        }

        public final void setNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
        }

        @SafeVarargs
        public final void setNodeIdsToRemove(String ... nodeIdsToRemove) {
            this.nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
        }

        public final Collection<Node> getNodes() {
            return this.nodes;
        }

        @Override
        public final Builder nodes(Collection<Node> nodes) {
            this.nodes = NodeListCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Node ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        public final void setNodes(Collection<Node> nodes) {
            this.nodes = NodeListCopier.copy(nodes);
        }

        @SafeVarargs
        public final void setNodes(Node ... nodes) {
            this.nodes(Arrays.asList(nodes));
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final NotificationConfiguration getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
        }

        public final String getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        public final Builder subnetGroup(String subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public final void setSubnetGroup(String subnetGroup) {
            this.subnetGroup = subnetGroup;
        }

        public final Collection<SecurityGroupMembership> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(SecurityGroupMembership ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final ParameterGroupStatus getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final Builder parameterGroup(ParameterGroupStatus parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public final void setParameterGroup(ParameterGroupStatus parameterGroup) {
            this.parameterGroup = parameterGroup;
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cluster> {
        public Builder clusterName(String var1);

        public Builder description(String var1);

        public Builder clusterArn(String var1);

        public Builder totalNodes(Integer var1);

        public Builder activeNodes(Integer var1);

        public Builder nodeType(String var1);

        public Builder status(String var1);

        public Builder clusterDiscoveryEndpoint(Endpoint var1);

        public Builder nodeIdsToRemove(Collection<String> var1);

        public Builder nodeIdsToRemove(String ... var1);

        public Builder nodes(Collection<Node> var1);

        public Builder nodes(Node ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        public Builder subnetGroup(String var1);

        public Builder securityGroups(Collection<SecurityGroupMembership> var1);

        public Builder securityGroups(SecurityGroupMembership ... var1);

        public Builder iamRoleArn(String var1);

        public Builder parameterGroup(ParameterGroupStatus var1);
    }
}

