/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NodeTypeSpecificValueMarshaller {
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final NodeTypeSpecificValueMarshaller INSTANCE = new NodeTypeSpecificValueMarshaller();

    private NodeTypeSpecificValueMarshaller() {
    }

    public static NodeTypeSpecificValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NodeTypeSpecificValue nodeTypeSpecificValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)nodeTypeSpecificValue, (String)"nodeTypeSpecificValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)nodeTypeSpecificValue.nodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)nodeTypeSpecificValue.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

