/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Node;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NodeMarshaller {
    private static final MarshallingInfo<String> NODEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").isBinary(false).build();
    private static final MarshallingInfo<Instant> NODECREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeCreateTime").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> NODESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeStatus").isBinary(false).build();
    private static final MarshallingInfo<String> PARAMETERGROUPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupStatus").isBinary(false).build();
    private static final NodeMarshaller INSTANCE = new NodeMarshaller();

    private NodeMarshaller() {
    }

    public static NodeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Node node, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)node, (String)"node");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)node.nodeId(), NODEID_BINDING);
            protocolMarshaller.marshall((Object)node.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)node.nodeCreateTime(), NODECREATETIME_BINDING);
            protocolMarshaller.marshall((Object)node.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)node.nodeStatus(), NODESTATUS_BINDING);
            protocolMarshaller.marshall((Object)node.parameterGroupStatus(), PARAMETERGROUPSTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

