/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.SubnetGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubnetGroupMarshaller {
    private static final MarshallingInfo<String> SUBNETGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").isBinary(false).build();
    private static final SubnetGroupMarshaller INSTANCE = new SubnetGroupMarshaller();

    private SubnetGroupMarshaller() {
    }

    public static SubnetGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubnetGroup subnetGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subnetGroup, (String)"subnetGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subnetGroup.subnetGroupName(), SUBNETGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)subnetGroup.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)subnetGroup.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(subnetGroup.subnets(), SUBNETS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

