/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.Parameter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParameterMarshaller {
    private static final MarshallingInfo<String> PARAMETERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterName").isBinary(false).build();
    private static final MarshallingInfo<String> PARAMETERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterType").isBinary(false).build();
    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterValue").isBinary(false).build();
    private static final MarshallingInfo<List> NODETYPESPECIFICVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeTypeSpecificValues").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").isBinary(false).build();
    private static final MarshallingInfo<String> DATATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataType").isBinary(false).build();
    private static final MarshallingInfo<String> ALLOWEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedValues").isBinary(false).build();
    private static final MarshallingInfo<String> ISMODIFIABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsModifiable").isBinary(false).build();
    private static final MarshallingInfo<String> CHANGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeType").isBinary(false).build();
    private static final ParameterMarshaller INSTANCE = new ParameterMarshaller();

    private ParameterMarshaller() {
    }

    public static ParameterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Parameter parameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parameter, (String)"parameter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parameter.parameterName(), PARAMETERNAME_BINDING);
            protocolMarshaller.marshall((Object)parameter.parameterTypeAsString(), PARAMETERTYPE_BINDING);
            protocolMarshaller.marshall((Object)parameter.parameterValue(), PARAMETERVALUE_BINDING);
            protocolMarshaller.marshall(parameter.nodeTypeSpecificValues(), NODETYPESPECIFICVALUES_BINDING);
            protocolMarshaller.marshall((Object)parameter.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)parameter.source(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)parameter.dataType(), DATATYPE_BINDING);
            protocolMarshaller.marshall((Object)parameter.allowedValues(), ALLOWEDVALUES_BINDING);
            protocolMarshaller.marshall((Object)parameter.isModifiableAsString(), ISMODIFIABLE_BINDING);
            protocolMarshaller.marshall((Object)parameter.changeTypeAsString(), CHANGETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

