/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dax.model.DAXRequest;
import software.amazon.awssdk.services.dax.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSubnetGroupRequest
extends DAXRequest
implements ToCopyableBuilder<Builder, CreateSubnetGroupRequest> {
    private final String subnetGroupName;
    private final String description;
    private final List<String> subnetIds;

    private CreateSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.subnetGroupName = builder.subnetGroupName;
        this.description = builder.description;
        this.subnetIds = builder.subnetIds;
    }

    public String subnetGroupName() {
        return this.subnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetGroupRequest)) {
            return false;
        }
        CreateSubnetGroupRequest other = (CreateSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.subnetGroupName(), other.subnetGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public String toString() {
        return ToString.builder((String)"CreateSubnetGroupRequest").add("SubnetGroupName", (Object)this.subnetGroupName()).add("Description", (Object)this.description()).add("SubnetIds", this.subnetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetGroupName": {
                return Optional.of(clazz.cast(this.subnetGroupName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DAXRequest.BuilderImpl
    implements Builder {
        private String subnetGroupName;
        private String description;
        private List<String> subnetIds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetGroupRequest model) {
            super(model);
            this.subnetGroupName(model.subnetGroupName);
            this.description(model.description);
            this.subnetIds(model.subnetIds);
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetGroupRequest build() {
            return new CreateSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends DAXRequest.Builder,
    CopyableBuilder<Builder, CreateSubnetGroupRequest> {
        public Builder subnetGroupName(String var1);

        public Builder description(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

