/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.Parameter;

@SdkInternalApi
public class ParameterMarshaller {
    private static final MarshallingInfo<String> PARAMETERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterName").build();
    private static final MarshallingInfo<String> PARAMETERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterType").build();
    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterValue").build();
    private static final MarshallingInfo<List> NODETYPESPECIFICVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeTypeSpecificValues").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final MarshallingInfo<String> DATATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataType").build();
    private static final MarshallingInfo<String> ALLOWEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedValues").build();
    private static final MarshallingInfo<String> ISMODIFIABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsModifiable").build();
    private static final MarshallingInfo<String> CHANGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeType").build();
    private static final ParameterMarshaller instance = new ParameterMarshaller();

    public static ParameterMarshaller getInstance() {
        return instance;
    }

    public void marshall(Parameter parameter, ProtocolMarshaller protocolMarshaller) {
        if (parameter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)parameter.parameterName(), PARAMETERNAME_BINDING);
            protocolMarshaller.marshall((Object)parameter.parameterType(), PARAMETERTYPE_BINDING);
            protocolMarshaller.marshall((Object)parameter.parameterValue(), PARAMETERVALUE_BINDING);
            protocolMarshaller.marshall(parameter.nodeTypeSpecificValues(), NODETYPESPECIFICVALUES_BINDING);
            protocolMarshaller.marshall((Object)parameter.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)parameter.source(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)parameter.dataType(), DATATYPE_BINDING);
            protocolMarshaller.marshall((Object)parameter.allowedValues(), ALLOWEDVALUES_BINDING);
            protocolMarshaller.marshall((Object)parameter.isModifiable(), ISMODIFIABLE_BINDING);
            protocolMarshaller.marshall((Object)parameter.changeType(), CHANGETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

